/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */

package org.postgresforest;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.List;

import org.postgresforest.apibase.BlobTask;
import org.postgresforest.apibase.EntrypointCommonResource;
import org.postgresforest.util.ForestTask;

public class ForestBlob implements Blob {
    
    private final EntrypointCommonResource epCommonResource;
    private final List<Blob> resBlobList;
    private final int execServerId;
    
    public ForestBlob(EntrypointCommonResource epCommonResource, List<Blob> resBlobList, final int execServerId) {
        this.epCommonResource = epCommonResource;
        this.resBlobList = resBlobList;
        this.execServerId = execServerId;
    }
    
    public InputStream getBinaryStream() throws SQLException {
        final ForestTask<InputStream> task = new BlobTask.GetBinaryStream(execServerId, resBlobList.get(execServerId));
        return epCommonResource.executeOneApi(task);
    }
    
    public byte[] getBytes(long pos, int length) throws SQLException {
        final ForestTask<byte[]> task = new BlobTask.GetBytes(execServerId, resBlobList.get(execServerId), pos, length);
        return epCommonResource.executeOneApi(task);
    }
    
    public long length() throws SQLException {
        final ForestTask<Long> task = new BlobTask.Length(execServerId, resBlobList.get(execServerId));
        return epCommonResource.executeOneApi(task);
    }
    
    public long position(Blob pattern, long start) throws SQLException {        
        final ForestTask<Long> task = new BlobTask.Position_BlobLong(execServerId, resBlobList.get(execServerId), pattern, start);
        return epCommonResource.executeOneApi(task);
    }
    
    public long position(byte[] pattern, long start) throws SQLException {
        final ForestTask<Long> task = new BlobTask.Position_BytesLong(execServerId, resBlobList.get(execServerId), pattern, start);
        return epCommonResource.executeOneApi(task);
    }
    
    public OutputStream setBinaryStream(long arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int setBytes(long arg0, byte[] arg1) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int setBytes(long arg0, byte[] arg1, int arg2, int arg3)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public void truncate(long arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
}
