/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */

package org.postgresforest;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.postgresforest.apibase.ArrayTask;
import org.postgresforest.apibase.EntrypointCommonResource;
import org.postgresforest.util.ForestTask;

public class ForestArray implements Array {
    
    private final EntrypointCommonResource epCommonResource;
    private final List<Array> resArrayList;
    private final int execServerId;
    
    public ForestArray(EntrypointCommonResource epCommonResource, List<Array> resArrayList, final int execServerId) {
        this.epCommonResource = epCommonResource;
        this.resArrayList = resArrayList;
        this.execServerId = execServerId;
    }
    
    public Object getArray() throws SQLException {
        final ForestTask<Object> task = new ArrayTask.GetArray(execServerId, resArrayList.get(execServerId));
        return epCommonResource.executeOneApi(task);
    }
    
    public Object getArray(Map<String, Class<?>> arg0) throws SQLException {
        final ForestTask<Object> task = new ArrayTask.GetArray_Map(execServerId, resArrayList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task);
    }
    
    public Object getArray(long index, int count) throws SQLException {
        final ForestTask<Object> task = new ArrayTask.GetArray_LongInt(execServerId, resArrayList.get(execServerId), index, count);
        return epCommonResource.executeOneApi(task);
    }
    
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        final ForestTask<Object> task = new ArrayTask.GetArray_LongIntMap(execServerId, resArrayList.get(execServerId), index, count, map);
        return epCommonResource.executeOneApi(task);
    }
    
    public int getBaseType() throws SQLException {
        final ForestTask<Integer> task = new ArrayTask.GetBaseType(execServerId, resArrayList.get(execServerId));
        return epCommonResource.executeOneApi(task);
    }
    
    public String getBaseTypeName() throws SQLException {
        final ForestTask<String> task = new ArrayTask.GetBaseTypeName(execServerId, resArrayList.get(execServerId));
        return epCommonResource.executeOneApi(task);
    }
    
    public ResultSet getResultSet() throws SQLException {
        final ForestTask<ResultSet> task = new ArrayTask.GetResultSet(execServerId, resArrayList.get(execServerId));
        final ResultSet newResultSet = epCommonResource.executeOneApi(task);
        final List<ResultSet> resultSetList = new ArrayList<ResultSet>(2);
        resultSetList.add(null);
        resultSetList.add(null);
        resultSetList.set(execServerId, newResultSet);
        final ForestResultSet newForestResultSet = new ForestResultSet(epCommonResource, resultSetList, execServerId, null);
        return newForestResultSet;
    }
    
    public ResultSet getResultSet(Map<String, Class<?>> arg0)
        throws SQLException {
        final ForestTask<ResultSet> task = new ArrayTask.GetResultSet_Map(execServerId, resArrayList.get(execServerId), arg0);
        final ResultSet newResultSet = epCommonResource.executeOneApi(task);
        final List<ResultSet> resultSetList = new ArrayList<ResultSet>(2);
        resultSetList.add(null);
        resultSetList.add(null);
        resultSetList.set(execServerId, newResultSet);
        final ForestResultSet newForestResultSet = new ForestResultSet(epCommonResource, resultSetList, execServerId, null);
        return newForestResultSet;
    }
    
    public ResultSet getResultSet(long index, int count) throws SQLException {
        final ForestTask<ResultSet> task = new ArrayTask.GetResultSet_LongInt(execServerId, resArrayList.get(execServerId), index, count);
        final ResultSet newResultSet = epCommonResource.executeOneApi(task);
        final List<ResultSet> resultSetList = new ArrayList<ResultSet>(2);
        resultSetList.add(null);
        resultSetList.add(null);
        resultSetList.set(execServerId, newResultSet);
        final ForestResultSet newForestResultSet = new ForestResultSet(epCommonResource, resultSetList, execServerId, null);
        return newForestResultSet;
    }
    
    public ResultSet getResultSet(long index, int count,
            Map<String, Class<?>> map) throws SQLException {
        final ForestTask<ResultSet> task = new ArrayTask.GetResultSet_LongIntMap(execServerId, resArrayList.get(execServerId), index, count, map);
        final ResultSet newResultSet = epCommonResource.executeOneApi(task);
        final List<ResultSet> resultSetList = new ArrayList<ResultSet>(2);
        resultSetList.add(null);
        resultSetList.add(null);
        resultSetList.set(execServerId, newResultSet);
        final ForestResultSet newForestResultSet = new ForestResultSet(epCommonResource, resultSetList, execServerId, null);
        return newForestResultSet;
    }
    
    public String toString() {
        return resArrayList.get(execServerId).toString();
    }
    
}
