/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest;

import java.sql.*;
import java.util.*;

import net.jcip.annotations.*;

import org.postgresforest.apibase.*;
import org.postgresforest.exception.*;
import org.postgresforest.util.*;

@NotThreadSafe public class Driver implements java.sql.Driver {
    
    /**
     * Class.forName時にDriverManagerに登録するためのstatic初期化ブロック
     */
    static {
        try {
            Class.forName("org.postgresql.Driver");
            java.sql.DriverManager.registerDriver(new org.postgresforest.Driver());
        } catch (SQLException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
    
    public boolean acceptsURL(String arg0) {
        try {
            ForestUrl.parseUrl(arg0);
            return true;
        } catch (ForestException e) {
            return false;
        }
    }
    
    public Connection connect(String arg0, Properties arg1) throws SQLException {
        final Pair2<ForestUrl, Map<String, String>> pair;
        try {
            pair = ForestUrl.parseUrl(arg0);
        } catch (NonForestUrlException e) {
            // ForestのURLと認識できない場合、nullを返す（JDBCの仕様参照）
            // これ以外の例外が発生した場合は、そのままユーザ側に返す
            return null;
        }
        final ForestUrl forestUrl = pair.getFirst();
        
        // EntrypointCommonResourceのコンストラクタに渡すoptionを作る。
        // 接続文字列中に含まれていたオプション列（ForestUrl.parseUrlで取得済み）と
        // Driver.connectの引数として与えられたオプション列とを合成する。
        final Properties newProp = (Properties) arg1.clone();
        final Map<String, String> inUrlProp = pair.getSecond();
        for (final Map.Entry<String, String> entry : inUrlProp.entrySet()) {
            newProp.setProperty(entry.getKey(), entry.getValue());
        }
        // ForestのJDBCエントリポイント（ForestConnection）と、このエントリポイントを
        // コントロールするオブジェクトを生成し、相互に関連付ける。
        final EntrypointCommonResource epResource = new EntrypointCommonResource(forestUrl, newProp);
        try {
            epResource.init();
            final List<PgUrl> pgUrlList = epResource.getUdbPgUrlList();
            final ForestTask<Connection> task0 = new DriverTask.Connect(0, pgUrlList.get(0), (Properties) newProp.clone());
            final ForestTask<Connection> task1 = new DriverTask.Connect(1, pgUrlList.get(1), (Properties) newProp.clone());
            final ForestTask<Connection> dummy0 = new DriverTask.Connect(0, null, null);
            final ForestTask<Connection> dummy1 = new DriverTask.Connect(1, null, null);
            
            // DriverクラスからConnectionを生成する際は、縮退している系のタスクを
            // ダミータスクとして用意しておく。このダミータスクは、何も行わない。
            // 通常の他のAPIであれば、executeXxxApiの内部で縮退状態などをチェックし、
            // 縮退と判断されればその系のリソースを解放してしまうためチェック関数の中で
            // 使用する対象のリソース解放を行っているため、そのまま実行して問題ないが
            // コネクションの生成に関しては全く新しいリソースから新規に生成するため、
            // API呼び出しの前の段階で縮退のチェックを行い、API実行を行わざるを得ない
            final List<Connection> conList = epResource.executeAllApiWithPreCheck(task0, task1, dummy0, dummy1);
            final ForestConnection con = new ForestConnection(epResource, conList);
            epResource.setTargetConnection(con);
            return con;
        } catch (SQLException e) {
            // EntrypointCommonResourceクラスの作成に成功した場合、必ずリリースが必要。
            // ここで例外が発生せず解放しなかった場合は、ForestConnectionクラスに解放を任せる。
            epResource.releaseEntryPointCommonResource();
            throw e;
        } catch (RuntimeException e) {
            epResource.releaseEntryPointCommonResource();
            throw e;
        }
    }
    
    public int getMajorVersion() {
        return 0;
    }
    
    public int getMinorVersion() {
        return 0;
    }
    
    public boolean jdbcCompliant() {
        return false;
    }
    
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info)
            throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
}
