/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.util;

import net.jcip.annotations.*;

/**
 *  異なる２種のクラスを保持するためだけのユーティリティクラス。
 *  主に関数の戻り値として複数の異なるクラスのオブジェクトを返す時に使用する。
 *  getFirst()で1番目の要素を、getSecond()で2番目の要素を取得できる。
 *  このクラスのインスタンスはImmutableであり、並行アクセスが可能。
 *  （但し各要素についてはそれぞれのスレッドセーフ性に依存する）
 */
@Immutable public final class Pair2<T1, T2> {
    private final T1 first;
    private final T2 second;
    public Pair2(final T1 first, final T2 second) {
        this.first = first;
        this.second = second;
    }
    public T1 getFirst() {
        return first;
    }
    public T2 getSecond() {
        return second;
    }
}
