/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.util;

import java.sql.SQLException;

public interface ForestCloseable {
    /**
     * JDBCインターフェースに定義されたcloseメソッドと同じもの。<br>
     * 本インターフェースの本メソッドは、子要素を再帰的に閉じる処理を行う。
     * （例えばForestStatementの本メソッドは、その子に当たるForestResultSetの
     * closeと、PostgreSQLのStatementをcloseする。ForestResultSetも同様に
     * 本インターフェースを実装しているため、子要素をcloseする）<br>
     * 但し、一度でもcloseを呼び出している場合、以降本メソッドは何も行わない。
     */
    void close() throws SQLException;
    
    /**
     * 本メソッドは、子要素の片方の系を再帰的に閉じる処理を行う。<br>
     * 子要素の片方の系のリソースがその後使われることがないように、そのリソースを
     * 保持している部分にnullを明示的にセットする。<br>
     * 一度でもclose()を呼び出している場合、以降本メソッドは何も行わない。
     * @param serverId リソースを閉じる系のID
     */
    void closeOneSide(int serverId);
}
