/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.apibase;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.*;
import java.util.concurrent.Callable;

import org.postgresforest.exception.ForestTaskNotExecutedException;

public final class ResultSetTask {
    
    public static final class GetString_Str implements Callable<String> {
        private final ResultSet res;
        private final String columnName;
        public GetString_Str(ResultSet res, String columnName) {
            this.res = res;
            this.columnName = columnName;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getString(columnName);
        }
    }
    
    public static final class GetString_Int implements Callable<String> {
        private final ResultSet res;
        private final int columnIndex;
        public GetString_Int(ResultSet res, int columnIndex) {
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getString(columnIndex);
        }
    }
    
    public static final class GetInt_Str implements Callable<Integer> {
        private final ResultSet res;
        private final String columnName;
        public GetInt_Str(ResultSet res, String columnName) {
            this.res = res;
            this.columnName = columnName;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getInt(columnName));
        }
    }
    
    public static final class GetInt_Int implements Callable<Integer> {
        private final ResultSet res;
        private final int columnIndex;
        public GetInt_Int(ResultSet res, int columnIndex) {
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getInt(columnIndex));
        }
    }
    
    public static final class GetAsciiStream_Int implements Callable<InputStream> {
        private final ResultSet res;
        private final int arg0;
        public GetAsciiStream_Int(ResultSet res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public InputStream call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getAsciiStream(arg0);
        }
    }
    
    public static final class GetAsciiStream_Str implements Callable<InputStream> {
        private final ResultSet res;
        private final String arg0;
        public GetAsciiStream_Str(ResultSet res, String arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public InputStream call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getAsciiStream(arg0);
        }
    }
    
    public static final class GetBigDecimal_IntInt implements Callable<BigDecimal> {
        private final ResultSet res;
        private final int arg0;
        private final int arg1;
        public GetBigDecimal_IntInt(ResultSet res, int arg0, int arg1) {
            this.res = res;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        @SuppressWarnings("deprecation")
        public BigDecimal call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBigDecimal(arg0, arg1);
        }
    }
    
    public static final class GetBigDecimal_StrInt implements Callable<BigDecimal> {
        private final ResultSet res;
        private final String arg0;
        private final int arg1;
        public GetBigDecimal_StrInt(ResultSet res, String arg0, int arg1) {
            this.res = res;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        @SuppressWarnings("deprecation")
        public BigDecimal call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBigDecimal(arg0, arg1);
        }
    }
    
    public static final class GetBinaryStream_Int implements Callable<InputStream> {
        private final ResultSet res;
        private final int arg0;
        public GetBinaryStream_Int(ResultSet res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public InputStream call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBinaryStream(arg0);
        }
    }
    
    public static final class GetBinaryStream_Str implements Callable<InputStream> {
        private final ResultSet res;
        private final String arg0;
        public GetBinaryStream_Str(ResultSet res, String arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public InputStream call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBinaryStream(arg0);
        }
    }
    
    public static final class GetBoolean_Int implements Callable<Boolean> {
        private final ResultSet res;
        private final int columnIndex;
        public GetBoolean_Int(ResultSet res, int columnIndex) {
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.getBoolean(columnIndex));
        }
    }
    
    public static final class GetBoolean_Str implements Callable<Boolean> {
        private final ResultSet res;
        private final String columnName;
        public GetBoolean_Str(ResultSet res, String columnName) {
            this.res = res;
            this.columnName = columnName;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.getBoolean(columnName));
        }
    }
    
    public static final class GetByte_Int implements Callable<Byte> {
        private final ResultSet res;
        private final int columnIndex;
        public GetByte_Int(ResultSet res, int columnIndex) {
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Byte call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Byte.valueOf(res.getByte(columnIndex));
        }
    }
    
    public static final class GetByte_Str implements Callable<Byte> {
        private final ResultSet res;
        private final String columnName;
        public GetByte_Str(ResultSet res, String columnName) {
            this.res = res;
            this.columnName = columnName;
        }
        public Byte call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Byte.valueOf(res.getByte(columnName));
        }
    }
    
    public static final class GetBytes_Int implements Callable<byte[]> {
        private final ResultSet res;
        private final int columnIndex;
        public GetBytes_Int(ResultSet res, int columnIndex) {
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public byte[] call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBytes(columnIndex);
        }
    }
    
    public static final class GetBytes_Str implements Callable<byte[]> {
        private final ResultSet res;
        private final String columnName;
        public GetBytes_Str(ResultSet res, String columnName) {
            this.res = res;
            this.columnName = columnName;
        }
        public byte[] call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getBytes(columnName);
        }
    }
    
    public static final class GetDate_Int implements Callable<Date> {
        private final ResultSet res;
        private final int columnIndex;
        public GetDate_Int(ResultSet res, int columnIndex) {
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Date call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getDate(columnIndex);
        }
    }
    
    public static final class GetDate_Str implements Callable<Date> {
        private final ResultSet res;
        private final String columnName;
        public GetDate_Str(ResultSet res, String columnName) {
            this.res = res;
            this.columnName = columnName;
        }
        public Date call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getDate(columnName);
        }
    }
    
    public static final class GetDouble_Int implements Callable<Double> {
        private final ResultSet res;
        private final int columnIndex;
        public GetDouble_Int(ResultSet res, int columnIndex) {
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Double call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Double.valueOf(res.getDouble(columnIndex));
        }
    }
    
    public static final class GetDouble_Str implements Callable<Double> {
        private final ResultSet res;
        private final String columnName;
        public GetDouble_Str(ResultSet res, String columnName) {
            this.res = res;
            this.columnName = columnName;
        }
        public Double call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Double.valueOf(res.getDouble(columnName));
        }
    }
    
    public static final class GetFloat_Int implements Callable<Float> {
        private final ResultSet res;
        private final int columnIndex;
        public GetFloat_Int(ResultSet res, int columnIndex) {
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Float call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Float.valueOf(res.getFloat(columnIndex));
        }
    }
    
    public static final class GetFloat_Str implements Callable<Float> {
        private final ResultSet res;
        private final String columnName;
        public GetFloat_Str(ResultSet res, String columnName) {
            this.res = res;
            this.columnName = columnName;
        }
        public Float call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Float.valueOf(res.getFloat(columnName));
        }
    }
    
    public static final class GetLong_Int implements Callable<Long> {
        private final ResultSet res;
        private final int columnIndex;
        public GetLong_Int(ResultSet res, int columnIndex) {
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Long call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Long.valueOf(res.getLong(columnIndex));
        }
    }
    
    public static final class GetLong_Str implements Callable<Long> {
        private final ResultSet res;
        private final String columnName;
        public GetLong_Str(ResultSet res, String columnName) {
            this.res = res;
            this.columnName = columnName;
        }
        public Long call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Long.valueOf(res.getLong(columnName));
        }
    }
    
    public static final class GetMetaData implements Callable<ResultSetMetaData> {
        private final ResultSet res;
        public GetMetaData(ResultSet res) {
            this.res = res;
        }
        public ResultSetMetaData call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getMetaData();
        }
    }
    
    public static final class GetObject_Int implements Callable<Object> {
        private final ResultSet res;
        private final int columnIndex;
        public GetObject_Int(ResultSet res, int columnIndex) {
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Object call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getObject(columnIndex);
        }
    }
    
    public static final class GetObject_Str implements Callable<Object> {
        private final ResultSet res;
        private final String columnName;
        public GetObject_Str(ResultSet res, String columnName) {
            this.res = res;
            this.columnName = columnName;
        }
        public Object call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getObject(columnName);
        }
    }
    
    public static final class GetShort_Int implements Callable<Short> {
        private final ResultSet res;
        private final int columnIndex;
        public GetShort_Int(ResultSet res, int columnIndex) {
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Short call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Short.valueOf(res.getShort(columnIndex));
        }
    }
    
    public static final class GetShort_Str implements Callable<Short> {
        private final ResultSet res;
        private final String columnName;
        public GetShort_Str(ResultSet res, String columnName) {
            this.res = res;
            this.columnName = columnName;
        }
        public Short call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Short.valueOf(res.getShort(columnName));
        }
    }
    
    public static final class GetTime_Int implements Callable<Time> {
        private final ResultSet res;
        private final int columnIndex;
        public GetTime_Int(ResultSet res, int columnIndex) {
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Time call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getTime(columnIndex);
        }
    }
    
    public static final class GetTime_Str implements Callable<Time> {
        private final ResultSet res;
        private final String columnName;
        public GetTime_Str(ResultSet res, String columnName) {
            this.res = res;
            this.columnName = columnName;
        }
        public Time call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getTime(columnName);
        }
    }
    
    public static final class GetTimestamp_Int implements Callable<Timestamp> {
        private final ResultSet res;
        private final int columnIndex;
        public GetTimestamp_Int(ResultSet res, int columnIndex) {
            this.res = res;
            this.columnIndex = columnIndex;
        }
        public Timestamp call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getTimestamp(columnIndex);
        }
    }
    
    public static final class GetTimestamp_Str implements Callable<Timestamp> {
        private final ResultSet res;
        private final String columnName;
        public GetTimestamp_Str(ResultSet res, String columnName) {
            this.res = res;
            this.columnName = columnName;
        }
        public Timestamp call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getTimestamp(columnName);
        }
    }
    
    public static final class GetUnicodeStream_Int implements Callable<InputStream> {
        private final ResultSet res;
        private final int columnIndex;
        public GetUnicodeStream_Int(ResultSet res, int columnIndex) {
            this.res = res;
            this.columnIndex = columnIndex;
        }
        @SuppressWarnings("deprecation")
        public InputStream call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getUnicodeStream(columnIndex);
        }
    }
    
    public static final class GetUnicodeStream_Str implements Callable<InputStream> {
        private final ResultSet res;
        private final String columnName;
        public GetUnicodeStream_Str(ResultSet res, String columnName) {
            this.res = res;
            this.columnName = columnName;
        }
        @SuppressWarnings("deprecation")
        public InputStream call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getUnicodeStream(columnName);
        }
    }
    
    
    public static final class Next implements Callable<Boolean> {
        private final ResultSet res;
        public Next(ResultSet res) {
            this.res = res;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.next());
        }
        
    }
    
    public static final class ClearWarning implements Callable<Void> {
        private final ResultSet res;
        public ClearWarning(ResultSet res) {
            this.res = res;
        }
        public Void call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            res.clearWarnings();
            return null;
        }
        
    }
    
    public static final class Close implements Callable<Void> {
        private final ResultSet res;
        public Close(ResultSet res) {
            this.res = res;
        }
        public Void call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            res.close();
            return null;
        }
        
    }
    
    public static final class FindColumn implements Callable<Integer> {
        private final ResultSet res;
        private final String arg0;
        public FindColumn(ResultSet res, String arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.findColumn(arg0));
        }
    }
    
    public static final class GetCursorName implements Callable<String> {
        private final ResultSet res;
        public GetCursorName(ResultSet res) {
            this.res = res;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getCursorName();
        }
    }
    
    public static final class GetWarnings implements Callable<SQLWarning> {
        private final ResultSet res;
        public GetWarnings(ResultSet res) {
            this.res = res;
        }
        public SQLWarning call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getWarnings();
        }
    }
    
    public static final class WasNull implements Callable<Boolean> {
        private final ResultSet res;
        public WasNull(ResultSet res) {
            this.res = res;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.wasNull());
        }
    }
    
    
}
