/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.apibase;

import java.sql.ResultSetMetaData;
import java.util.concurrent.Callable;

import org.postgresforest.exception.ForestTaskNotExecutedException;

public final class ResultSetMetaDataTask {
    
    public static final class GetCatalogName implements Callable<String> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetCatalogName(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getCatalogName(arg0);
        }
    }
    
    public static final class GetColumnCount implements Callable<Integer> {
        private final ResultSetMetaData res;
        public GetColumnCount(ResultSetMetaData res) {
            this.res = res;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getColumnCount());
        }
    }
    
    public static final class GetColumnDisplaySize implements Callable<Integer> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetColumnDisplaySize(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getColumnDisplaySize(arg0));
        }
    }
    
    public static final class GetColumnLabel implements Callable<String> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetColumnLabel(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getColumnLabel(arg0);
        }
    }
    
    public static final class GetColumnName implements Callable<String> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetColumnName(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getColumnName(arg0);
        }
    }
    
    public static final class GetColumnType implements Callable<Integer> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetColumnType(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getColumnType(arg0));
        }
    }
    
    public static final class GetColumnTypeName implements Callable<String> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetColumnTypeName(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getColumnTypeName(arg0);
        }
    }
    
    public static final class GetPrecision implements Callable<Integer> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetPrecision(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getPrecision(arg0));
        }
    }
    
    public static final class GetScale implements Callable<Integer> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetScale(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.getScale(arg0));
        }
    }
    
    public static final class GetSchemaName implements Callable<String> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetSchemaName(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getSchemaName(arg0);
        }
    }
    
    public static final class GetTableName implements Callable<String> {
        private final ResultSetMetaData res;
        private final int arg0;
        public GetTableName(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public String call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return res.getTableName(arg0);
        }
    }
    
    public static final class IsAutoIncrement implements Callable<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsAutoIncrement(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isAutoIncrement(arg0));
        }
    }
    
    public static final class IsCaseSensitive implements Callable<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsCaseSensitive(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isCaseSensitive(arg0));
        }
    }
    
    public static final class IsCurrency implements Callable<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsCurrency(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isCurrency(arg0));
        }
    }
    
    public static final class IsDefinitelyWritable implements Callable<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsDefinitelyWritable(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isDefinitelyWritable(arg0));
        }
    }
    
    public static final class IsNullable implements Callable<Integer> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsNullable(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public Integer call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(res.isNullable(arg0));
        }
    }
    
    public static final class IsReadOnly implements Callable<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsReadOnly(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isReadOnly(arg0));
        }
    }
    
    public static final class IsSearchable implements Callable<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsSearchable(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isSearchable(arg0));
        }
    }
    
    public static final class IsSigned implements Callable<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsSigned(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isSigned(arg0));
        }
    }
    
    public static final class IsWritable implements Callable<Boolean> {
        private final ResultSetMetaData res;
        private final int arg0;
        public IsWritable(ResultSetMetaData res, int arg0) {
            this.res = res;
            this.arg0 = arg0;
        }
        public Boolean call() throws Exception {
            if (res == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(res.isWritable(arg0));
        }
    }
}
