/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.vm.gsc;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * GscMetaData
 * グローバルシステムカタログ情報クラス.
 * 
 * グローバルシステムカタログの各種情報の取得
 * @version $Revision: 1.1.2.1 $
 * @since 3.1 
 * 
 */
public class GscMetaData {

    private GscData m_gsc;
    
    /**
     * @param gsc
     */
    public GscMetaData(GscData gsc) {
        super();
        m_gsc = gsc;
    }
    
    /**
     * 
     * @return
     * @throws SQLException
     * @since
     */
    public ResultSet getBrokenLog()
    throws SQLException{

		String sql = "select * from FOREST_BROKENLOG";

		return m_gsc.executeQueryGSC(sql);
    
    }
    /**
     * 
     * @return
     * @throws SQLException
     * @since
     */
    public ResultSet getBrokenLog(int serverId)
    throws SQLException{

		String sql = "select * from FOREST_BROKENLOG where serverid = " + serverId ;

		return m_gsc.executeQueryGSC(sql);
    
    }
    
    
    public ResultSet getConfig()
    throws SQLException{
		String sql = "select * from FOREST_CONFIG";

		return m_gsc.executeQueryGSC(sql);
    
    }
    
    public ResultSet getConfig(String configId)
    throws SQLException{
		String sql = "select * from FOREST_CONFIG where configid ='" + configId+ "'";

		return m_gsc.executeQueryGSC(sql);
    
    }
    
    public ResultSet getGSC()
    throws SQLException{
		String sql = "select * from FOREST_GSC";

		return m_gsc.executeQueryGSC(sql);
    
    }
    
    
    public ResultSet getHash()
    throws SQLException{
		String sql = "select * from FOREST_HASH";

		return m_gsc.executeQueryGSC(sql);
    
    }
    
    public ResultSet getServDB()
    throws SQLException{
		String sql = "select * from FOREST_SERVDB";

		return m_gsc.executeQueryGSC(sql);
    
    }


    public ResultSet getServer()
    throws SQLException{
		String sql = "select * from FOREST_SERVER";

		return m_gsc.executeQueryGSC(sql);
    
    }
    
    public ResultSet getTablePart()
    throws SQLException{
		String sql = "select * from FOREST_TABLEPART";

		return m_gsc.executeQueryGSC(sql);
    
    }
    
    public ResultSet getTablePartDtl()
    throws SQLException{
		String sql = "select * from FOREST_TABLEPARTDTL";

		return m_gsc.executeQueryGSC(sql);
    
    }
    
    /**
     * 
     * @param serverId
     * @return
     * @throws SQLException
     * @since
     */
    public boolean isServerBroken(int serverId)
    throws SQLException{
		String sql = "select status from FOREST_SERVER where serverid = " + serverId ;

		ResultSet rs = m_gsc.executeQueryGSC(sql);
		if( rs.next() ){
			if(rs.getInt("STATUS") == ServerInfo.SERVER_RUNNING ){
			    return false;
			}
			    
		}
    	
    	return true;
    	
		
    }
    
    
    

    
    
    
}
