package org.postgresforest.tool.tests;

import java.io.*;
import java.sql.*;
import junit.framework.*;

import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.Config;
import org.postgresforest.tool.lib.Instance;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.ForestToolException;

/*
 * 試験内容
 *  - GSC複製
 *  - GSC比較
 *  - GSC削除
 */
public class TestGSCdata3 extends ForestToolTestCase {

	public void setUp()
	{
	}

	public void tearDown()
	{
	}

	/*
	 * GSCの複製（正常系）
	 */
    public void testCopy001()
    {
		GSCdata gsc = null;

		initializeGSC();

		try {
            gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
            assertTrue(gsc!=null);

			Instance ins2 = gsc.registerInstance("localhost", "9999");
			assertTrue(ins2!=null);
			
			/*
			 * 新規インスタンスにGSCをコピー
			 */
			assertTrue( gsc.copy(ins2) );

			gsc.close();
		}
        catch (ForestToolException e)
        {
			System.out.println(e.getMessage());
			fail();
        }
	} 

	/*
	 * GSCの複製（異常系/nullチェック）
	 */
    public void testCopy002()
    {
		GSCdata gsc = null;

		initializeGSC();

		try {
            gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
            assertTrue(gsc!=null);

			Instance ins2 = gsc.registerInstance("localhost", "9999");
			assertTrue(ins2!=null);
			
			/*
			 * 新規インスタンスにGSCをコピー
			 */
			assertTrue( gsc.copy(null)==false );

			gsc.close();
		}
        catch (ForestToolException e)
        {
			System.out.println(e.getMessage());
			fail();
        }
	} 

	/*
	 * GSCの複製（正常系・シナリオ）
	 */
    public void testCopy101()
    {
		GSCdata gsc = null;

		initializeGSC();

		try {
            gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
            assertTrue(gsc!=null);

			Instance ins2 = gsc.registerInstance("localhost", "9999");
			assertTrue(ins2!=null);
			
			/*
			 * 新規インスタンスにGSCをコピー
			 */
			assertTrue( gsc.copy(ins2) );

			/*
			 * GSCのあるインスタンス一覧を取得
			 */
			int[] ins = gsc.getGscInstances();
			assertTrue(ins.length==2);
			assertTrue(ins[0]==0);
			assertTrue(ins[1]==1);

			/*
			 * 新規インスタンスのGSCと比較
			 */
			assertTrue( gsc.equals(ins2) );

			gsc.close();

			/*
			 * 反対側に接続して比較
			 */
            gsc = new GSCdata("localhost", "9999", "gsctest",
							  user, pass);
            assertTrue(gsc!=null);

			/*
			 * 既存インスタンスを取得
			 */
			ins2 = gsc.getInstance(0);
			
			/*
			 * 既存インスタンスのGSCと比較
			 */
			assertTrue( gsc.equals(ins2) );

			gsc.close();
		}
        catch (ForestToolException e)
        {
			System.out.println(e.getMessage());
			fail();
        }
	} 


	/*
	 * GSCの削除
	 */
    public void testDrop001()
    {
		GSCdata gsc = null;

		initializeGSC();

		try {
			dropdb("gsctest", "9999");

            gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
            assertTrue(gsc!=null);

			Instance ins = gsc.registerInstance("localhost", "9999");
			assertTrue( ins!=null );

			assertTrue( gsc.copy(ins) );

			gsc.close();
		}
        catch (ForestToolException e)
        {
			System.out.println(e.getMessage());
			fail();
        }
	} 

	public static void main(String[] args)
	{
		junit.textui.TestRunner.run(TestGSCdata3.class);
	}
}
