package org.postgresforest.tool.lib;

import java.text.MessageFormat;

/**
 * メッセージカタログクラス
 *
 * 引数とともに、メッセージをフォーマットして返却する。
 */
public class GT {
	/**
	 * 引数が無い場合
	 */
	public static String tr(String msg)
	{
		return msg;
	}

	/**
	 * 引数が1つの場合
	 */
	public static String tr(String msg, String arg0)
	{
		return MessageFormat.format(msg, new Object[] {arg0});
	}

	/**
	 * 引数が2つの場合
	 */
	public static String tr(String msg, String arg0, String arg1)
	{
		return MessageFormat.format(msg, new Object[] {arg0,arg1});
	}

	/**
	 * 引数が3つの場合
	 */
	public static String tr(String msg, String arg0, String arg1, String arg2)
	{
		return MessageFormat.format(msg, new Object[] {arg0,arg1,arg2});
	}

	/*
	 * 引数が4つ以上の場合（Objectの配列で渡す必要がある）
	 */
	public static String tr(String msg, Object[] args)
	{
		return MessageFormat.format(msg,args);
	}
}
