/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.user;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.postgresforest.tool.action.UserMngAction;
import org.postgresforest.tool.util.CommonTableContentProvider;
import org.postgresforest.tool.util.EnableSelection;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.view.ViewBase;
import org.postgresforest.tool.view.action.AddUserAction;
import org.postgresforest.tool.view.action.DelUserAction;

/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class UserView extends ViewBase {

	public static final String ID = "org.postgresforest.tool.view.UserView";
	
	private TableViewer viewer = null;
	

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
		Table table = new Table(parent,
				SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.SINGLE|SWT.BORDER);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		TableColumn column = new TableColumn(table, SWT.LEFT, 0);
		column.setText(Messages.getString("form.user"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 1);
		column.setText(Messages.getString("form.attribute"));
		column.setWidth(150);
		
		viewer = new TableViewer(table);
		
		viewer.setContentProvider(new CommonTableContentProvider());
		
		viewer.setLabelProvider(new UserLabelProvider());
		viewer.addSelectionChangedListener(new ISelectionChangedListener(){
		    public void selectionChanged(SelectionChangedEvent event){
		    
		        ISelection selection = event.getSelection();
		        setEnabledAction(DelUserAction.ID,selection);
		        
		    }
    								
		});
		//MASUCOMMENT ENbN΍
		createContextMenu(viewer.getTable());
		getSite().setSelectionProvider(viewer);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#setFocus()
	 */
	public void setFocus() {
	}
	
	/**
	 * I[U[擾
	 * 
	 * @return [U[
	 */
	public String getSelectUser() {
		
		Table tbl = viewer.getTable();
		TableItem[] selectItem = tbl.getSelection();
		if(selectItem.length == 1){
			return selectItem[0].getText(0);
		}
		else{
			return "";
		}
	}
	
	/**
	 * [U[ꗗ̎擾
	 *
	 */
	public ArrayList getUserList() {
		ArrayList list = null;
		//
		UserMngAction userMng = new UserMngAction(getGsc());
		try {
			list = userMng.getUserList();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return list;
	}
	public void update() {
	    if(!isLogin()){
			viewer.setInput(null);
	        setEnabledAction(AddUserAction.ID,EnableSelection.FALSE);
	        return;
	    }
		//[U[ꗗ擾
		ArrayList userList = getUserList();

		//TableViewerɃ[U[ꗗݒ
		viewer.setInput(userList);
        setEnabledAction(AddUserAction.ID,EnableSelection.TRUE);

	}
	

}
