/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.tablecolumn;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Item;
import org.postgresforest.tool.bean.ColumnInfo;

/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TableColumnCellModifier implements ICellModifier {
	private TableViewer viewer;
	
	protected boolean m_editable = false;
	
	public TableColumnCellModifier(TableViewer viewer) {
		this.viewer = viewer;
	}
	
	public boolean canModify(Object element, String property) {
		return m_editable;
	}
	
	public Object getValue(Object element, String property) {
		ColumnInfo info = (ColumnInfo) element;

		if (property == "attribute"){
			return new Boolean(info.isPartition());
		}
		return null;
	}
	
	public void modify(Object element, String property, Object value) {
		if (element instanceof Item) {
			element = ((Item) element).getData();
		}
		ColumnInfo info = (ColumnInfo) element;

		if (property == "attribute") {
			info.setPartition(((Boolean) value).booleanValue());
		}
		// e[uEr[XV
		viewer.update(element, null);
	}

	/**
	 * @param editable editable ݒB
	 */
	public void setEditable(boolean editable) {
		m_editable = editable;
	}
}