/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IViewPart;
import org.postgresforest.tool.action.ChangePriority;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.dialog.partition.priority.PartitionPriorityDialog;
import org.postgresforest.tool.util.SessionProperty;
import org.postgresforest.tool.view.ViewControl;

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class ChangePriorityAction extends ActionBase {
	public static final String ID = "org.postgresforest.tool.view.action.ChangePriorityAction";
	protected PartitionPriorityDialog dialog;
	/* ( Javadoc)
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	public void init(IViewPart view) {
		// TODO ꂽ\bhEX^u
		super.init(view);
		dialog = new PartitionPriorityDialog();

	}

	/* ( Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {

		//e[uꗗ擾
		String selectDb = (String)SessionProperty.get("selectDb");
		TableInfo tableInfo = (TableInfo)SessionProperty.get("tableInfo");

		dialog.setServers(tableInfo.getServer());
		
		
		if( !tableInfo.isPartition() ){
			dialog.setPartCount(0);
		}else{
			dialog.setPartCount(tableInfo.getPartCount());
		}
		
		//_CAO\
		if( dialog.open() == Window.OK){

			//f[^x[X擾
			
			ChangePriority changePriority = new ChangePriority((GSCdata)SessionProperty.get("gsc"));
			try {
				changePriority.execute(selectDb, tableInfo);
			} catch (Exception e) {
			}

			ViewControl.updateUserDataView("",selectDb, tableInfo.getName());
			
		}
		
	}


}
