/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view;

import java.util.ArrayList;
import java.util.Iterator;

import org.postgresforest.tool.action.TableList;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.ErrorLog;
import org.postgresforest.tool.util.SessionProperty;
import org.postgresforest.tool.view.dbinstance.DbInstanceView;
import org.postgresforest.tool.view.ddl.DdlView;
import org.postgresforest.tool.view.menu.AdminMenuView;
import org.postgresforest.tool.view.partitionlist.PartitionListView;
import org.postgresforest.tool.view.tablecolumn.TableColumnView;
import org.postgresforest.tool.view.tablelist.TableListView;

/**
 *
 * ViewControl
 * @version $Revision: 1.1.1.1 $
 * @since 
 */
public class ViewControl {



	/**
	 * 
	 * @return
	 * @since
	 */
    static protected GSCdata getGsc() {
        return (GSCdata)SessionProperty.get("gsc");
    }

    
    static public void updateUserDataView(String viewID, String dbName) {
       
		//Iꂽe[uŃ[Uj[̑IύX
        if ( !viewID.equals(AdminMenuView.ID)) {

            AdminMenuView viewPart = (AdminMenuView)ViewUtil.findView(AdminMenuView.ID);
    		if( viewPart != null ){
    		    viewPart.select(dbName, null);
    		    return;
    		}

        }

        
        //ZbVvpeB̃e[uNA
		SessionProperty.set("selectDb", dbName);
        
        SessionProperty.set("tableInfo", null);
        
        
		TableList tableListAction = new TableList(getGsc());
//TODOMASU Ae[uXgr[͗vȂ̂ŁA폜ł͂
//		try {
//			ArrayList tableList =  tableListAction.getTableList(dbName);
//
//			//e[uXgViewXV
//			TableListView tableListView = (TableListView)ViewUtil.findView(TableListView.ID);
//			//TODOMASU tableListViewNULL̏ꍇɂՃV
//			if(tableListView !=null){
//				tableListView.setTableList(tableList);
//			}
//		} catch (Exception e) {
//			ErrorLog.log("", e);
//		}

		//DBXgViewXV
		DbInstanceView dbInstanceView = (DbInstanceView)ViewUtil.findView(DbInstanceView.ID);
		if(dbInstanceView == null){
		    dbInstanceView = (DbInstanceView)ViewUtil.updateView(DbInstanceView.ID,true,false);
		}
		dbInstanceView.select(dbName);
		
	    //DDLr[\
		ViewUtil.updateView(DdlView.ID);
		
		//TODOMASU TableListView͂ȂȂ̂łȂ
		//e[uꗗr[\
//		ViewUtil.updateView(TableListView.ID,true, true);

	    //e[uڃr[\
		ViewUtil.updateView(TableColumnView.ID);
		
	    //p[eBVr[\
		ViewUtil.updateView(PartitionListView.ID);
		ViewUtil.updateView(DdlView.ID);


    
    }
    
    static public void updateUserDataView(String viewID, String dbName, String tableName) {


		//Iꂽe[uŃ[Uj[̑IύX
        if ( !viewID.equals(AdminMenuView.ID)) {

            AdminMenuView viewPart = (AdminMenuView)ViewUtil.findView(AdminMenuView.ID);
    		if( viewPart != null ){
    		    viewPart.select(dbName, tableName);
    		    return;
    		}

        }
            
	        SessionProperty.set("selectDb", dbName);
	        
	        SessionProperty.set("tableInfo", null);
	        
			TableList tableListAction = new TableList(getGsc());
			try {
				ArrayList tableList =  tableListAction.getTableList(dbName);
	
				TableListView tableListView = (TableListView)ViewUtil.findView(TableListView.ID);
				if(tableListView != null){
					tableListView.setTableList(tableList);
				}
				for (Iterator iter = tableList.iterator(); iter
						.hasNext();) {
					TableInfo tableInfo = (TableInfo) iter.next();
					
					if( tableName.equals(tableInfo.getName()) ){
	    				TableInfo tableInfo2 =  tableListAction.getTableInfo(dbName, tableInfo);
	                    //ZbVvpeB̃e[uNA
	    				SessionProperty.set("tableInfo", tableInfo2);
	
					}
					
				}
	    		
			
			} catch (Exception e) {
				ErrorLog.log("", e);
			}

            
        //DDLr[\
        ViewUtil.updateView(DdlView.ID);

        //f[^x[XCX^Xr[\
		DbInstanceView dbInstanceView = (DbInstanceView)ViewUtil.findView(DbInstanceView.ID);
		if(dbInstanceView == null){
		    dbInstanceView = (DbInstanceView)ViewUtil.updateView(DbInstanceView.ID,true,false);
		}
		dbInstanceView.select(dbName);
//TODOMASU e[uꗗr[͕\Ȃ
//        //e[uꗗr[\
//        TableListView tableListView = (TableListView)ViewUtil.updateView(TableListView.ID);
//        //TODOMASU \ĂȂTableListView͖Ăǂ̂ł́H
////		if(tableListView == null){
////			tableListView = (TableListView)ViewUtil.updateView(TableListView.ID,true,false);
////		}
//		if(tableListView != null){
//			tableListView.select(tableName);
//		}
	    //e[uڃr[\
        ViewUtil.updateView(TableColumnView.ID,true,true);
		
	    //p[eBVr[\
        ViewUtil.updateView(PartitionListView.ID,true,false);
    
    }

    static public void clearUserDataView() {
        
		//[U[f[^x[Xݒ肷B
		SessionProperty.set("selectDb", null);
        //ZbVvpeB̃e[uNA
        SessionProperty.set("tableInfo", null);

        //DDLr[\
        ViewUtil.updateView(DdlView.ID);
		
		//e[uꗗr[\
        ViewUtil.updateView(TableListView.ID);

	    //e[uڃr[\
        ViewUtil.updateView(TableColumnView.ID);
		
	    //p[eBVr[\
        ViewUtil.updateView(PartitionListView.ID);

        
    }
}
