/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.util;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.SQLException;
import java.text.DecimalFormat;

/**
 *@NGC^.
 *  DDL̃e[uAуCfbNXp[eBVɉāAϊ
 */

public class ReWriter {


	/** p[eBVe[uSUFFIXtH[}bg */
	protected static DecimalFormat m_dcFmt = new DecimalFormat("00");
	/**
	 * NGCg.
	 * 
	 * e[ue[uɕϊ
	 * 
	 * @param ddl	ddl
	 * @param tableName	e[u
	 * @param PatitionCount	p[eBV
	 * @return	CgꂽSQL̃Xg
	 */
	static public String[] rewrite(String ddl, String tableName, int PatitionCount) {
		String[] distDdl = new String[PatitionCount];
		
		for (int i = 0; i < distDdl.length; i++) {
			distDdl[i] = ddl.replaceFirst(tableName, tableName + "_" + m_dcFmt.format(i));
			
		}
		return distDdl;		
	}
	
	/**
	 * 
	 * NGCgiCREATE INDEXŁj.
	 * 
	 * e[ue[uɕϊBCfbNXCfbNX_NNŕϊ
	 * 
	 * @param ddl	ddl
	 * @param indexName	CfbNX
	 * @param tableName	e[u
	 * @param PatitionCount	p[eBV
	 * @return	CgꂽSQL̃Xg
	 */
	static public String[] rewrite(String ddl, String indexName, String tableName, int PatitionCount) {
		String[] distDdl = new String[PatitionCount];
		//CfbNXƃe[ũCg" on "splitSQLɑ΂Ďs
		String ddlSplit[] = ddl.split(" on ");
		for (int i = 0; i < distDdl.length; i++) {
			distDdl[i] = ddlSplit[0].replaceFirst(indexName, indexName + "_" + m_dcFmt.format(i))
						+ " on "
						+ ddlSplit[1].replaceFirst(tableName, tableName + "_" + m_dcFmt.format(i));
		}
		return distDdl;
	}
	
	/**
	 * SQL𕶎('ň͂܂ꂽ)ȊOɕϊ
	 * @param sql ΏSQL
	 * @return ̎ɕϊꂽSQL
	 * @throws SQLException
	 */
	static public String toLowerSql(String sql) throws IOException{

		StringBuffer distSql = new StringBuffer();

		//g[NiCU[擾
		StringReader fr = new StringReader(sql);
		StreamTokenizer tokenizer = new StreamTokenizer(fr);
		tokenizer.resetSyntax();
		tokenizer.wordChars('a', 'z');
		tokenizer.wordChars('A', 'Z');
		tokenizer.wordChars('_', '_');
		tokenizer.wordChars('*', '*');
		tokenizer.whitespaceChars('\t', '\t');
		tokenizer.whitespaceChars('\n', '\n');
		tokenizer.whitespaceChars('\r', '\r');
		tokenizer.eolIsSignificant(false);
		tokenizer.lowerCaseMode(true);
		tokenizer.quoteChar('\'');
		tokenizer.quoteChar('"');

		//ȊOɕϊ

		int token;
		while ((token = tokenizer.nextToken()) != StreamTokenizer.TT_EOF) {
			switch (token) {
				case StreamTokenizer.TT_WORD :
					distSql.append(tokenizer.sval);
					break;
				case '\'' :
				case '"' :
					distSql.append((char)token + tokenizer.sval + (char)token);
					break;
				default :
					distSql.append((char) tokenizer.ttype);
			}
		}

		return distSql.toString();
	}
}
