/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.partition;

import java.text.DecimalFormat;
import java.util.ArrayList;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.bean.ServerPartition2Info;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.dialog.CommonDialog;
import org.postgresforest.tool.util.CommonTableContentProvider;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.util.SessionProperty;

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class Partition2Dialog extends CommonDialog {

	
	protected static DecimalFormat m_dcFmt = new DecimalFormat("00");
	protected int m_partCount;
	
	/**
	 * @param parent
	 */
	public Partition2Dialog() {
		
		
	}

	/* ( Javadoc)
	 * @see org.postgresforest.tool.m_dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
	 */
	protected void customizeDialog(Composite parent) {
		
		
		//e[u
		Table table = new Table(parent,
				SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION |SWT.HIDE_SELECTION | SWT.SINGLE|SWT.BORDER );
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		TableColumn column = new TableColumn(table, SWT.CENTER );
		column.setText(Messages.getString("form.instance"));
		column.setWidth(100);
		for (int i = 1; i <= m_partCount; i++) {

			column = new TableColumn(table, SWT.CENTER, i);
			column.setText(m_dcFmt.format(i-1));
			column.setWidth(25);
			
		}
		
		
		TableViewer viewer = new TableViewer(table);
		
		viewer.setContentProvider(new CommonTableContentProvider());
		viewer.setLabelProvider(new Partition2LabelProvider());
		
		
		//ZbVvpeBe[uꗗ擾
		TableInfo tableInfo = (TableInfo)SessionProperty.get("tableInfo");
		ArrayList servers = tableInfo.getServer();
		
		for (int i = 0; i < servers.size(); i++) {
			ServerPartition2Info partition2Info = new ServerPartition2Info((ServerInfo)servers.get(i), m_partCount);
			servers.set(i,partition2Info);
		}
		
		
		//TableViewerɃe[uꗗݒ
		viewer.setInput(servers);

		
		CheckboxCellEditor checkEditer = new CheckboxCellEditor(table, SWT.BORDER);		

		String[] properties = new String[m_partCount + 1];
		CellEditor[] editors = new CellEditor[m_partCount + 1];
		for (int i = 0; i < m_partCount; i++) {
			//ŏ̃J̓CX^XJ

			properties[i+1] = Integer.toString(i);
			editors[i+1] = checkEditer;
		}

		

		
		// JEvpeB̐ݒ
		viewer.setColumnProperties(properties);

	    //ZEGfB^̐ݒ
	    viewer.setCellEditors(editors);
	    
	    //ZEfBt@C̐ݒ
	    viewer.setCellModifier(new Partition2ColumnCellModifier(viewer));
		
		
		
		
	}
	/* ( Javadoc)
	 * @see org.eclipse.jface.window.Window#configureShell(org.eclipse.swt.widgets.Shell)
	 */
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.getString("title.user.partition"));
	
	}

	/**
	 * @param partCount partCount ݒB
	 */
	public void setPartCount(int partCount) {
		m_partCount = partCount;
	}
}
