/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.hash;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.postgresforest.tool.dialog.CommonDialog;
import org.postgresforest.tool.dialog.ValidateResult;
import org.postgresforest.tool.util.Messages;

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class HashDialog extends CommonDialog {

	private static final String HASH01 = "Hash01";
    private Text m_fileNameTxt;
	private Text m_classNameTxt;
	private Text m_descriptionTxt;

	private String m_fileName;
	private String m_className;
	private String m_description;

	protected Button m_fileBtn;

	protected void customizeDialog(Composite parent) {
		
		GridLayout layout = new GridLayout(3, true);
		parent.setLayout(layout);
		GridData gridData;

		//NX
		new Label(parent,SWT.NONE).setText(Messages.getString("from.class.name"));
		m_classNameTxt = new Text(parent, SWT.BORDER );
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment=GridData.FILL;
		m_classNameTxt.setLayoutData(gridData);
		
		//
		new Label(parent,SWT.NONE).setText(Messages.getString("form.description"));
		m_descriptionTxt = new Text(parent, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment=GridData.FILL;
		m_descriptionTxt.setLayoutData(gridData);

		//t@CFx
		new Label(parent,SWT.NONE).setText(Messages.getString("form.file.name"));
		m_fileNameTxt = new Text(parent,SWT.BORDER| SWT.READ_ONLY);
		m_fileBtn = new Button(parent, SWT.NONE);
		m_fileBtn.setText(Messages.getString("button.read"));

		m_fileBtn.addMouseListener(new org.eclipse.swt.events.MouseAdapter() { 
			public void mouseUp(org.eclipse.swt.events.MouseEvent e) {    
				Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
				FileDialog dialog = new FileDialog(shell, SWT.OPEN);
				String file = dialog.open();
				if(file != ""){
					m_fileNameTxt.setText(file);
				}
			}
		});

		

	}

	public String getClassName() {
		return m_className;
	}
	public String getDescription() {
		return m_description;
	}
	public String getFileName() {
		return m_fileName;
	}
	protected void okPressed() {
		m_className = m_classNameTxt.getText();
		m_description = m_descriptionTxt.getText();
		m_fileName = m_fileNameTxt.getText();

		super.okPressed();
	}
	/* ( Javadoc)
	 * @see org.eclipse.jface.window.Window#configureShell(org.eclipse.swt.widgets.Shell)
	 */
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.getString("title.admin.hash"));
	
	}
    /* ( Javadoc)
     * @see org.postgresforest.tool.dialog.CommonDialog#validate()
     */
    protected ValidateResult validate() {
		ValidateResult result = new ValidateResult();
		final String DEFALUT_CLASS_PAT = "(.*[.]|^)" + HASH01 + "$";
		if (m_className.matches(DEFALUT_CLASS_PAT)) {
			result.setMessage(Messages.getString("errors.hash.defalut", HASH01));
			result.setValid(false);
		}

		
		return result;
    }
	
}
