/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.brokenlog;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.postgresforest.tool.bean.BrokenLogInfo;
import org.postgresforest.tool.dialog.CommonDialog;
import org.postgresforest.tool.util.Messages;

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class BrokenLogDialog extends CommonDialog {
	private boolean m_modifyFlg = false;
	private BrokenLogInfo m_brokenLogInfo;

	/** T[oID */
	private Text m_serverId; 
	/** URL */
	private Text m_url; 
	/** Q */
	private Text m_datetime; 
	/** NCAg */
	private Text m_client; 
	/** QbZ[W */
	private Text m_msg; 
	/** QXe[^X */
	private Text m_status; 
	/** QNG */
	private Text m_query; 
	

	
	/**
	 * @param modifyFlg
	 */
	public BrokenLogDialog(boolean modifyFlg) {
		super();
		m_modifyFlg = modifyFlg;
	}

	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		// ^Cg
		newShell.setText(Messages.getString("title.admin.brokenlog"));
	}

	
	protected void customizeDialog(Composite parent) {
		
		GridLayout layout = new GridLayout(2, true);
		parent.setLayout(layout);
		GridData gridData;

		//TODOMASU ȂH
//		//T[oID
//		new Label(parent,SWT.NONE).setText(Messages.getString("form.brokenlog.serverid"));
//		int style = SWT.BORDER;
//		if(m_modifyFlg){
//			style |= SWT.READ_ONLY;
//		}
//		m_serverId = new Text(parent, style );
//		gridData = new GridData();
//		gridData.horizontalAlignment=GridData.FILL;
//		m_serverId.setLayoutData(gridData);
		//URL
		new Label(parent,SWT.NONE).setText(Messages.getString("form.brokenlog.url"));
		
		m_url = new Text(parent,SWT.BORDER | SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_url.setLayoutData(gridData);
		
		//Q
		new Label(parent,SWT.NONE).setText(Messages.getString("form.brokenlog.datetime"));
		m_datetime = new Text(parent, SWT.BORDER | SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_datetime.setLayoutData(gridData);

		//NCAg
		new Label(parent,SWT.NONE).setText(Messages.getString("form.brokenlog.client"));
		m_client = new Text(parent,SWT.BORDER | SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_client.setLayoutData(gridData);

		//QbZ[W
		new Label(parent,SWT.NONE).setText(Messages.getString("form.brokenlog.msg"));
		m_msg = new Text(parent,SWT.MULTI|SWT.BORDER|SWT.H_SCROLL|SWT.V_SCROLL|SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_msg.setLayoutData(gridData);
		
		//Xe[^X
		new Label(parent,SWT.NONE).setText(Messages.getString("form.brokenlog.status"));
		m_status = new Text(parent,SWT.BORDER|SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_msg.setLayoutData(gridData);
		
		//NG
		new Label(parent,SWT.NONE).setText(Messages.getString("form.brokenlog.query"));
		m_query = new Text(parent,SWT.MULTI|SWT.BORDER|SWT.H_SCROLL|SWT.V_SCROLL|SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_query.setLayoutData(gridData);

		if(m_modifyFlg){
//			m_serverId.setText(Integer.toString(m_brokenLogInfo.getServerid())); 
			m_url.setText(m_brokenLogInfo.getServerUrl());
			//TODOMASU ̃tH[}bgw肪܂łĂȂ
			m_datetime.setText(m_brokenLogInfo.getDatetime().toString()); 
			m_client.setText(m_brokenLogInfo.getClient()); 
			m_msg.setText(m_brokenLogInfo.getMsg()); 
			m_status.setText(m_brokenLogInfo.getStatus());
			m_query.setText(m_brokenLogInfo.getQuery()); 
			
		}else{
			m_brokenLogInfo = new BrokenLogInfo();	
		}

		
		
	}
//TODOMASU ȂH
//	protected void okPressed() {
////		m_brokenLogInfo.setConfigId(m_serverId.getText());
////		//MASUCOMMENT@񂩂Date	^ɒăZbg镔
////		m_brokenLogInfo.setDatetime(new Date(m_datetime.getText()));
////		m_brokenLogInfo.setClient(m_client.getText());
////		m_brokenLogInfo.setMsg(m_msg.getText());
////		m_brokenLogInfo.setQuery(m_query.getText());
////		
////
////		super.okPressed();
//	}
	public BrokenLogInfo getBrokenLogInfo() {
		return m_brokenLogInfo;
	}
	public void setBrokenLogInfo(BrokenLogInfo brokenLogInfo) {
		m_brokenLogInfo = brokenLogInfo;
	}
	
	protected void createButtonsForButtonBar(Composite parent) {
		// create OK button by default
		createButton(parent, IDialogConstants.CLOSE_ID, IDialogConstants.CLOSE_LABEL,
				true);
	}

	protected void buttonPressed(int id){
		if(id == IDialogConstants.CLOSE_ID){
			close();
		}
	}
}
