/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;

import org.postgresql.jdbc3.Jdbc3Connection;

/**
 *
 * GSCDataCheck
 * @version $Revision: 1.1.1.1 $
 * @since 
 */
public class GSCDataCheck extends GSCdata {

    public static final String FOREST_SERVER_TBL = "forest_server";
	public static final String FOREST_SERVDB_TBL = "forest_servdb";
	public static final String FOREST_TABLEPART_TBL = "forest_tablepart";
	public static final String FOREST_TABLEPARTDTL_TBL = "forest_tablepartdtl";
	public static final String FOREST_PARTATR_TBL = "forest_partatr";
	public static final String FOREST_GSC_TBL = "forest_gsc";
	public static final String FOREST_CONFIG_TBL = "forest_config";
	public static final String FOREST_HASH_TBL = "forest_hash";

	
    protected HashMap m_tbleChkMap;
    /**
     * @param userPassword
     */
    public GSCDataCheck(Properties userPassword) {
        super(userPassword);
        initTableChkMap();
    }
    /**
     * @param user
     * @param password
     */
    public GSCDataCheck(String user, String password) {
        super(user, password);
        initTableChkMap();
     }
    
    /**
     * 
     * @since 
     */
    protected void initTableChkMap() {

        m_tbleChkMap = new HashMap();
        
        m_tbleChkMap.put(FOREST_SERVER_TBL, m_sqlResource.getString("select.gsc.server.check"));
        m_tbleChkMap.put(FOREST_SERVDB_TBL, m_sqlResource.getString("select.gsc.servdb.check"));
        m_tbleChkMap.put(FOREST_TABLEPART_TBL, m_sqlResource.getString("select.gsc.tablepart.check"));
        m_tbleChkMap.put(FOREST_TABLEPARTDTL_TBL, m_sqlResource.getString("select.gsc.tablepartdtl.check"));
        m_tbleChkMap.put(FOREST_PARTATR_TBL, m_sqlResource.getString("select.gsc.partatr.check"));
        m_tbleChkMap.put(FOREST_GSC_TBL, m_sqlResource.getString("select.gsc.gsc.check"));
        m_tbleChkMap.put(FOREST_CONFIG_TBL, m_sqlResource.getString("select.gsc.config.check"));
        m_tbleChkMap.put(FOREST_HASH_TBL, m_sqlResource.getString("select.gsc.hash.check"));
        
        
    }
    
    /**
     * 
     * @since 
     */
    public String[] getTableNames() {
        return (String[])m_tbleChkMap.keySet().toArray(new String[0]);
        
    }
    
    /**
     * e[ur
     * 
     * rpSQLw肵āAe[urs
     * 
     * @return	true:Afalse:Ⴀ
     */
    public boolean checkTableData(String tableName) {
    
    	String sql = (String)m_tbleChkMap.get(tableName);
    
    	boolean ret = _checkTableData(sql);
    	
    	return ret;
    
    }
    /**
     * e[ur
     * 
     * w肳ꂽSQLsēꂽʂAr
     * 
     * @param sql	rf[^擾pSQL
     * @return	true:Afalse:Ⴀ
     */
    protected boolean _checkTableData(String sql) {
    	boolean ret = true;
    	String connectUrl = "";
    	
    	StringBuffer[] result = new StringBuffer[m_Connection.size()];
    	for (int i = 0; i < m_Connection.size(); i++) {
    		
    		Connection con = (Connection) m_Connection.get(i);
    		try{
    			connectUrl = ((Jdbc3Connection) con).getURL();
    	
    			result[i] = new StringBuffer();
    	
    			Statement smt = con.createStatement();
    			ResultSet rs =	smt.executeQuery(sql);
    	
    	
    			ResultSetMetaData rsmeta = rs.getMetaData();
    			while(rs.next()){
    				for( int j = 1; j <= rsmeta.getColumnCount(); j ++ ){
    					result[i].append(rs.getString(j));
    				}
    			}
    	
    			smt.close();
    	
    		} catch (SQLException e) {
    			setErrInfo(connectUrl, e);
    			return false;
    		}
    	
    		
    	}
    	
    	String primaryData = result[0].toString();		
    	for (int j = 1; j < result.length; j++) {
    	
    	
    		String backupData = result[j].toString();
    		if(primaryData.compareTo(backupData) != 0){
    			ret = false;
    		}
    	}		
    	return ret;
    }
}
