package org.postgresforest.tool.commandline.action;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

import org.postgresforest.tool.action.HashAction;
import org.postgresforest.tool.bean.HashInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

/**
 * p[eBV֐ւ̃R}hCc[p̃ANV񋟂NX
 */
public class HashActions {

	/**
	 * p[eBV֐̍쐬
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 */	
	public void create(CommandParser cp, GSCdata gsc) {
		// nbV֐̎擾
		String className = (String)cp.getHashName().get(0);
		String fileName = (String)cp.getHashFile().get(0);
		//IvV擾
		String description = ""; //$NON-NLS-1$
		Iterator it = cp.getHashDescript().iterator();
		while(it.hasNext()){
			description += (String)it.next();
		}

		// HashClass̃oCgXg[̎擾
		byte[] byteImg = null;
		try {
			byteImg = getFileByteImage(fileName);
		} catch (FileNotFoundException e) {
			System.out.println(MessagesCommandLine.getString("cui.error.command.filenotfound", new Object[]{fileName})) ; //$NON-NLS-1$
			return;
		} catch (Exception e1) {
			System.out.println(MessagesCommandLine.getString("cui.error.hash.create", new Object[]{className})) ; //$NON-NLS-1$
			e1.printStackTrace();
			return;
		}		
		
		HashAction hashAction = new HashAction(gsc);
		if (hashAction.addHash(className, description, byteImg)) {
			System.out.println(MessagesCommandLine.getString("cui.message.hash.create", new Object[]{className})) ; //$NON-NLS-1$			
			return;	
		}
		System.out.println(MessagesCommandLine.getString("cui.error.hash.create", new Object[]{className})) ; //$NON-NLS-1$
	}
	
	/**
	 * p[eBV֐̍폜
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 */	
	public void drop(CommandParser cp, GSCdata gsc) {
		String id = (String)cp.getHashName().get(0);
		//폜
		if(id != ""){ //$NON-NLS-1$
			HashAction hashAction = new HashAction(gsc);
			try {
				if(hashAction.delHash(id)){
					System.out.println(MessagesCommandLine.getString("cui.message.hash.drop", new Object[] {id})) ; //$NON-NLS-1$
					return;
				}
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		System.out.println(MessagesCommandLine.getString("cui.error.hash.drop", new Object[] {id})) ; //$NON-NLS-1$
	}

	/**
	 * p[eBV֐̕\
	 * @param gsc GSCw̐ڑ
	 */	
	public void show(GSCdata gsc) {
	    ArrayList hashList = null;

		//T[o擾
		HashAction hashAction = new HashAction(gsc);
		try {
			hashList = hashAction.getHashList();
		} catch (Exception e) {
			System.out.println(MessagesCommandLine.getString("cui.error.hash.show")) ; //$NON-NLS-1$
			e.printStackTrace();
			return;
		}
		
		//Table\
		System.out.println(MessagesCommandLine.getString("cui.message.hash.show")) ; //$NON-NLS-1$
		Iterator it = hashList.iterator();
		System.out.println(" HASHNAME\t| DESCRIPTION"); //$NON-NLS-1$
		System.out.println("----------------------------------------------"); //$NON-NLS-1$
		while (it.hasNext()) {
			HashInfo hashInfo = (HashInfo)it.next();
			System.out.print(hashInfo.getName() + "\t| "); //$NON-NLS-1$
			System.out.println(hashInfo.getDescription());
		}		
		
	}
	
	/**
	 * @param fileName
	 * @return
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	private byte[] getFileByteImage(String fileName) throws FileNotFoundException, IOException {
		byte[] buf = new byte[64];
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		FileInputStream in = new FileInputStream(fileName);

		int nBytes;

		while ((nBytes = in.read(buf)) > 0)
			out.write(buf, 0, nBytes);

		in.close();

		byte[] byteImg = out.toByteArray();
		out.close();
		return byteImg;
	}
}
