/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import org.postgresforest.tool.bean.AddDbInfo;
import org.postgresforest.tool.bean.DbLinkInfo;
import org.postgresforest.tool.bean.ServerDumpDataInfo;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.db.DbBase;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.db.UserData;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.StringReplaceUtil;

/**
 * DB쐬ANV
 * 
 * <pre>
 * ͏"AddDbForm"Aȉ̏sB
 * EGSCXV
 *   forestservdbփR[h}
 * Ef[^x[X쐬
 *   CREATE DATABASE R}hs
 * </pre>
 *
 */
public class DbAction extends ActionBase {
	/** 쐬[h萔  */
	
	/**
	 * @param gsc
	 */
	public DbAction(GSCdata gsc) {
		super(gsc);
		// TODO ꂽRXgN^[EX^u
	}
	/**
	 * DB쐬C
	 * 
	 * @see org.postgresforest.tool.action.DbAction#addDb()
	 */
	public boolean add(AddDbInfo addForm) {


		String dbName = addForm.getDb();
		String option = addForm.getOption();
		int makeMode = addForm.getMakeMode();
		ArrayList serverDumpDataList = addForm.getServer();
		
		//T[oIDXg쐬
		Integer[] idList = new Integer[serverDumpDataList.size()];
		for(int i = 0; i < serverDumpDataList.size(); i++){
			ServerDumpDataInfo info = (ServerDumpDataInfo)serverDumpDataList.get(i);
			if(info.isChkFlag() == true){
				idList[i] = new Integer(info.getId());
			}
			else{
				idList[i] = null;
			}
		}
		
		//_vt@CXg쐬
		String[] dumpList = new String[serverDumpDataList.size()];
		for(int i = 0; i < serverDumpDataList.size(); i++){
			ServerDumpDataInfo info = (ServerDumpDataInfo)serverDumpDataList.get(i);
			dumpList[i] = info.getDumpData();
		}
		
		//[UDBNX
		UserData userData = new UserData(m_gsc.getUserPassword());

		try {

			//GSC֐ڑ
			if (!connect(m_gsc)) {
				return false; 
			}
			
			//--------------
			// f[^x[Xo^`FbN@
			//--------------
			ArrayList dbList = m_gsc.getDbList();
			boolean dbCheck = false;
			for (int i = 0; i < dbList.size(); i++) {
				String checkDbName = (String)dbList.get(i);
				if (dbName.compareTo(checkDbName) == 0) {
					dbCheck = true;
					break;
				}
			}
			//쐬[hɃf[^x[Xo^`FbNʂ𔻒f
			if (makeMode == DbBase.DB_ADD && 
				dbCheck == false) {					//f[^x[Xǉ
				StringReplaceUtil strUtil =
					new StringReplaceUtil(MessagesCommandLine.getString("errors.db.notadd"));
				strUtil.set(1, dbName);
				
				System.out.println(strUtil.get());

				return false; 
			}
			else if (makeMode == DbBase.DB_SHIFT && 
				dbCheck == true) {						//f[^x[Xڍs
				StringReplaceUtil strUtil =
					new StringReplaceUtil(MessagesCommandLine.getString("errors.db.notshift"));
				strUtil.set(1, dbName);
				
				System.out.println(strUtil.get());
				return false; 
			}

			//--------------
			// GSC@XV
			//--------------

			//T[oIDŃCX^X擾
			ArrayList serverList;
			try {
				serverList = m_gsc.getServerList(idList);
			} catch (SQLException e) {
				setAccessErrs(m_gsc);
				return false; 
			}
			//forest_servdbXV
			if (!m_gsc.addServDb(dbName, idList)) {
				m_gsc.rollback();
				setAccessErrs(m_gsc);
				return false; 
			}
				
			if (makeMode == DbBase.DB_ADD) {	//f[^x[Xǉ
				//forest_tablepartdtlXV
				if (!m_gsc.setDbAdd(dbName, idList)) {
					m_gsc.rollback();
					setAccessErrs(m_gsc);
					return false; 
				}
			}
						
			//--------------
			// [Uf[^x[X񐶐
			//--------------
			//ڑZbg
			for (Iterator iter = serverList.iterator(); iter.hasNext();) {
				ServerInfo serverInfo = (ServerInfo) iter.next();
				String host = serverInfo.getHost();
				String port = serverInfo.getPort();

				//[UDBNXɒǉ
				userData.addUrl(host, port, dbName);
				
				int serverId = serverInfo.getId();
				for (int i = 0; i < idList.length; i++) {
					if (idList[i] != null) {
						if (idList[i].intValue() == serverId) {
							userData.addDumpData(dumpList[i]);
							break;
						}
					}
				}
			}

			//--------------
			// [Uf[^x[X쐬
			//--------------
			//template1DBɐڑ
			if (connectTemlate(userData)) {
				//--------------
				// f[^x[X݃`FbN@
				//--------------
				ArrayList dbMapList = userData.getDbMapList();
				String[] urls = userData.getURL();
				ArrayList servers = new ArrayList();
				for (int i = 0; i < urls.length ; i++) {
					HashMap dbNameMap = (HashMap) dbMapList.get(i);
					if (dbNameMap.containsKey(dbName)) {
						servers.add(urls[i]);
					}
				}
				userData.rollback();
				
				//[Uf[^x[X쐬
				if (!userData.makeDB(option, makeMode)) {
					//f[^x[X폜
					userData.delDB();
					m_gsc.rollback();
					userData.rollback();
					setAccessErrs("errors.db.create", userData);
					
					System.out.println("errors.db.create");
					return false; 
				}
				else{
					//XgAs
					if (makeMode == DbBase.DB_ADD || makeMode == DbBase.DB_SHIFT) {	//f[^x[XǉEڍs
						if (!userData.execRestore(dbName)) {
							//f[^x[X폜
							userData.delDB();
							m_gsc.rollback();
							userData.rollback();
							setAccessErrs("errors.db.restore", userData);

//							System.out.println("errors.db.restore");
							
							return false; 
						}
					}
					
					//forest_tablepart,forest_tablepartdtlXV
					if (makeMode == DbBase.DB_SHIFT) {	//f[^x[Xڍs
						userData.close();
						
						//[Uf[^x[Xɐڑ
						boolean ret = true;
 						if (connect(userData)) {
							//e[u擾
							ArrayList tableList = userData.getTableList();
							
							//forest_tablepartdtlXV
							if (!m_gsc.setDbShift(dbName, tableList, serverList)) {
								ret = false;
							}
						}
						else{
							ret = false;
						}
						
						//forest_tablepartdtlXVɎs
						if (!ret){
							//template1DBɐڑ
							if (connectTemlate(userData)) {
								//f[^x[X폜
								userData.delDB();
							}
							m_gsc.rollback();
							userData.rollback();
							setAccessErrs(m_gsc);
							return false; 
						}
					}
				}
				
				m_gsc.commit();
			}

		} finally {
			m_gsc.close();
			userData.close();
		}

		return true; 
	}
	/**
	 * f[^x[X폜C
	 * 
	 * @see org.postgresforest.tool.action.AdminActionBase#executeMain(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, javax.servlet.http.HttpSession, org.postgresforest.tool.db.GSCdata)
	 */
	public boolean del(ArrayList dbLinkList)  {


		UserData userData = new UserData(m_gsc.getUserPassword());

		try {

			//--------------
			// GSC@XV
			//--------------

			if (!connect(m_gsc)) {
				return false; 
			}

			Iterator iter = dbLinkList.iterator();
			while (iter.hasNext()) {
				DbLinkInfo dnLinkInfo = (DbLinkInfo) iter.next();
				String dbName = dnLinkInfo.getName();

				ArrayList serveList = dnLinkInfo.getServer();
				Iterator serverIter = serveList.iterator();
				while (serverIter.hasNext()) {
					ServerInfo serverInfo = (ServerInfo) serverIter.next();
					if (serverInfo.isChkFlag()) {
						int serverId = serverInfo.getId();

						String host = serverInfo.getHost();
						String port = serverInfo.getPort();

						//e[u݂郆[U[DB폜łȂ悤ɂ
						//e[uXg擾
						ArrayList tableList;
						try {
							tableList = m_gsc.getTableList(dbName);
						} catch (SQLException e) {
							m_gsc.rollback();
							setAccessErrs(m_gsc);
							return false; 
						}
						//e[u΃f[^x[Xo^𒆎~
						if (tableList.size() > 0) {
							m_gsc.rollback();
							System.out.println(MessagesCommandLine.getString("errors.gsc.table.exist"));
							return false; 
						}

						//[UDBNXɒǉ
						userData.addUrl(host, port, dbName);

						//forest_servdbXV
						if (!m_gsc.delServDb(dbName, serverId)) {
							m_gsc.rollback();
							setAccessErrs(m_gsc);
							return false; 

						}

					}

				}
			}
			m_gsc.commit();

			//--------------
			// [Uf[^x[X폜
			//--------------
			//ڑ
			if (!connectTemlate(userData)) {
				return false; 
			}
			//[Uf[^x[X폜
			if (!userData.delDB()) {
				setAccessErrs("errors.db.drop", userData);
				return false; 
			}
			
		} finally {
			m_gsc.close();
			userData.close();
		}

		return true; 

	}
	/**
	 * f[^x[Xꗗ쐬
	 * 
	 */
	public ArrayList getList() throws Exception {

 
		//f[^쐬
		ArrayList dbList = null;
		try {
			//ڑ
			if (!connect(m_gsc)) {
				throw new Exception();
			}
			
			//f[^x[Xꗗ쐬
			dbList = m_gsc.getDbList();

		} finally {
			m_gsc.close();
		}

		return dbList;
	}	
}
