#!/bin/sh

export PATH=/usr/local/pgsql816/bin:$PATH
export CLASSPATH=/usr/local/forest32/share/postgresql-8.0-313.jdbc3.jar

## -------------
## check 1
## -------------
psql postgres -p 15432 <<EOF
drop table t1;
create table t1 ( uid integer primary key, name text );
insert into t1 values ( 101, '101' );
EOF

psql postgres -p 15433 <<EOF
drop table t1;
create table t1 ( uid integer primary key, name text );
insert into t1 values ( 101, '101' );
EOF

echo check 1
java -classpath .:${CLASSPATH} TableDiff \
  jdbc:postgresql://localhost:15432/postgres \
  jdbc:postgresql://localhost:15433/postgres \
  snaga snaga t1


## -------------
## check 2
## -------------
psql postgres -p 15432 <<EOF
insert into t1 values ( 102, '102' );
EOF

echo check 2
java -classpath .:${CLASSPATH} TableDiff \
  jdbc:postgresql://localhost:15432/postgres \
  jdbc:postgresql://localhost:15433/postgres \
  snaga snaga t1

## -------------
## check 3
## -------------
psql postgres -p 15432 <<EOF
delete from t1 where uid=102;
insert into t1 values ( 103, null );
EOF

psql postgres -p 15433 <<EOF
insert into t1 values ( 103, null );
EOF

echo check 3

java -classpath .:${CLASSPATH} TableDiff \
  jdbc:postgresql://localhost:15432/postgres \
  jdbc:postgresql://localhost:15433/postgres \
  snaga snaga t1

## -------------
## check 4
## -------------
psql postgres -p 15432 <<EOF
insert into t1 values ( 104, null );
EOF

psql postgres -p 15433 <<EOF
insert into t1 values ( 104, '104' );
EOF

echo check 4

java -classpath .:${CLASSPATH} TableDiff \
  jdbc:postgresql://localhost:15432/postgres \
  jdbc:postgresql://localhost:15433/postgres \
  snaga snaga t1


## -------------
## check 5
## -------------
psql postgres -p 15432 <<EOF
delete from t1 where uid=104;
insert into t1 values ( 105, '105' );
EOF

psql postgres -p 15433 <<EOF
delete from t1 where uid=104;
insert into t1 values ( 105, null );
EOF

echo check 5

java -classpath .:${CLASSPATH} TableDiff \
  jdbc:postgresql://localhost:15432/postgres \
  jdbc:postgresql://localhost:15433/postgres \
  snaga snaga t1

