/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.postgresforest.Driver;
import org.postgresforest.jdbc3.AbstractJdbc3Connection;
import org.postgresforest.util.GT;
import org.postgresforest.util.PSQLException;
import org.postgresforest.vm.LogUtil;
import org.postgresforest.vm.Logger;
import org.postgresforest.vm.ParamValue;
import org.postgresforest.vm.Parser;
import org.postgresforest.vm.PartitionColumnInfo;
import org.postgresforest.vm.QueryInfo;
import org.postgresforest.vm.err.ForestSQLState;
import org.postgresforest.vm.gsc.GscData;

public class ReWriter {
    public static final int TYPE_NONE = -1;
    public static final int TYPE_PARTITION = 0;
    public static final int TYPE_DISPERSION = 1;
    public static final int TYPE_PARALLEL = 2;
    protected String m_srcSql;
    protected GscData m_gsc;
    protected ArrayList m_info;
    protected int m_queyType = -1;
    protected static DecimalFormat m_dcFmt = new DecimalFormat("00");
    protected Parser m_paser;
    protected LogUtil m_logUtil;

    public ReWriter(GscData gsc) {
        this.m_gsc = gsc;
        this.m_logUtil = this.m_gsc.getLogUtil();
    }

    public ArrayList getQueryInfo() {
        return this.m_info;
    }

    public void rewrite(Parser parser) throws SQLException {
        this.clearSrcSql();
        this.m_paser = parser;
        this.m_srcSql = this.m_paser.getSrcSql();
        switch (this.m_paser.getType()) {
            case 15: {
                this.makeSelectQuery(this.m_paser);
                break;
            }
            case 6: {
                this.makeDeleteQuery(this.m_paser);
                break;
            }
            case 10: {
                this.makeInsertQuery(this.m_paser);
                break;
            }
            case 18: {
                this.makeUpdateQuery(this.m_paser);
                break;
            }
            case 200: {
                this.makeTruncateQuery(this.m_paser);
                break;
            }
            default: {
                this.makeOtherQuery();
            }
        }
        if (Driver.logInfo) {
            for (int i = 0; i < this.m_info.size(); ++i) {
                QueryInfo qi = (QueryInfo)this.m_info.get(i);
                AbstractJdbc3Connection con = (AbstractJdbc3Connection)qi.getConnection();
                this.m_logUtil.info("ReWriter Result: Connection URL = " + con.getURL());
                this.m_logUtil.info("ReWriter Result: Partition No = " + qi.getPartNo());
                this.m_logUtil.info("ReWriter Result: The rewritten SQL = " + qi.getSql());
                String[] tables = qi.getTables();
                String allname = "";
                try {
                    for (int j = 0; j < tables.length; ++j) {
                        allname = allname + tables[j] + ",";
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.m_logUtil.info("ReWriter Result: Extraction Table Name = " + allname);
            }
        }
    }

    protected void makeSelectQuery(Parser ps) throws SQLException {
        int i;
        HashMap<Integer, QueryInfo> qiMap = new HashMap<Integer, QueryInfo>();
        int partTableIdx = -1;
        String[] tables = ps.getTables();
        for (i = 0; i < tables.length; ++i) {
            String tbl = tables[i];
            if (!this.m_gsc.isPartition(tbl)) continue;
            partTableIdx = i;
            HashMap cols = ps.getWhereColumns(tbl);
            ArrayList colNames = this.m_gsc.getPartCol(tbl);
            if (colNames.size() == 1) {
                PartitionColumnInfo colinfo = (PartitionColumnInfo)colNames.get(0);
                String colName = colinfo.getName();
                if (cols.containsKey(colName)) {
                    HashMap partCol = new HashMap();
                    ArrayList values = (ArrayList)cols.get(colName);
                    for (int j = 0; j < values.size(); ++j) {
                        partCol.put(colName, values.get(j));
                        int partNum = this.m_gsc.getPartNo(tbl, partCol, 0);
                        Integer numKey = new Integer(partNum);
                        if (qiMap.containsKey(numKey)) continue;
                        QueryInfo qi = new QueryInfo();
                        qi.setTable(tables);
                        qi.setPartNo(partNum);
                        qiMap.put(numKey, qi);
                    }
                } else {
                    int num = this.m_gsc.getPartCount(tbl);
                    for (int j = 0; j < num; ++j) {
                        QueryInfo qi = new QueryInfo();
                        qi.setTable(tables);
                        qi.setPartNo(j);
                        qiMap.put(new Integer(j), qi);
                    }
                }
            } else {
                HashMap partCol = new HashMap();
                for (int j = 0; j < colNames.size(); ++j) {
                    ArrayList values;
                    PartitionColumnInfo colinfo = (PartitionColumnInfo)colNames.get(j);
                    String colName = colinfo.getName();
                    if (cols.containsKey(colName)) {
                        values = (ArrayList)cols.get(colName);
                        if (values.size() != 1) {
                            partCol.clear();
                            break;
                        }
                    } else {
                        partCol.clear();
                        break;
                    }
                    partCol.put(colName, values.get(0));
                }
                if (!partCol.isEmpty()) {
                    int partNum = this.m_gsc.getPartNo(tbl, partCol, 0);
                    QueryInfo qi = new QueryInfo();
                    qi.setTable(tables);
                    qi.setPartNo(partNum);
                    qiMap.put(new Integer(partNum), qi);
                    break;
                }
                int num = this.m_gsc.getPartCount(tbl);
                for (int j = 0; j < num; ++j) {
                    QueryInfo qi = new QueryInfo();
                    qi.setTable(tables);
                    qi.setPartNo(j);
                    qiMap.put(new Integer(j), qi);
                }
            }
            break;
        }
        if (qiMap.size() > 1 && ps.isForUpdate()) {
            throw new PSQLException(GT.tr("FOR UPDATE is set as two or more partitions."), ForestSQLState.INTERNAL_ERROR);
        }
        if (partTableIdx != -1) {
            for (i = partTableIdx + 1; i < tables.length; ++i) {
                if (!this.m_gsc.isPartition2(tables[i])) continue;
                throw new PSQLException(GT.tr("It cannot be processed in Partition table 2."), ForestSQLState.INTERNAL_ERROR);
            }
        }
        if (1 < qiMap.size() && (ps.hasGroupBy() && ps.getGroupList().size() == 0 || ps.hasGroupBy() && !ps.hasExecFunction() || ps.hasOrderBy() && ps.getOrderList().size() == 0 || ps.hasGroupBy() && ps.hasOrderBy() && ps.hasLimit() || ps.hasOffset() || ps.hasFunction() || ps.hasJoinTable() || ps.hasDistinct() || ps.hasUnion() || ps.hasHaving())) {
            qiMap.clear();
        }
        if (qiMap.isEmpty()) {
            if (partTableIdx != -1 && this.m_gsc.isPartition2(tables[partTableIdx])) {
                throw new PSQLException(GT.tr("It cannot be processed in Partition table 2."), ForestSQLState.INTERNAL_ERROR);
            }
            if (ps.isForUpdate()) {
                if (Driver.forestTestLog) {
                    System.out.println("The query type was specified in parallel.");
                }
                if (Driver.logInfo) {
                    this.m_logUtil.info("The query type was specified in parallel.");
                }
                this.m_queyType = 2;
                ArrayList conlist = null;
                conlist = tables.length <= 0 ? this.m_gsc.getDistServerList() : this.m_gsc.getDistServerList(tables[0], tables);
                for (int i2 = 0; i2 < conlist.size(); ++i2) {
                    QueryInfo qf = new QueryInfo();
                    qf.setConnection((Connection)conlist.get(i2));
                    qf.setSql(this.m_srcSql);
                    qf.setTable(tables);
                    this.m_info.add(qf);
                }
            } else {
                if (Driver.forestTestLog) {
                    System.out.println("The query type was specified to be dispersion.");
                }
                if (Driver.logInfo) {
                    this.m_logUtil.info("The query type was specified to be dispersion.");
                }
                this.m_queyType = 1;
                Connection con = null;
                con = tables.length <= 0 ? this.m_gsc.getDistServer() : this.m_gsc.getDistServer(tables);
                QueryInfo qf = new QueryInfo();
                qf.setConnection(con);
                qf.setSql(this.m_srcSql);
                qf.setTable(tables);
                this.m_info.add(qf);
            }
        } else if (ps.isForUpdate()) {
            if (Driver.forestTestLog) {
                System.out.println("The query type was specified in parallel.");
            }
            if (Driver.logInfo) {
                this.m_logUtil.info("The query type was specified in parallel.");
            }
            this.m_queyType = 2;
            QueryInfo qiSrc = (QueryInfo)qiMap.values().iterator().next();
            int partNum = qiSrc.getPartNo();
            String table = tables[partTableIdx];
            Parser.TableInfo tableInfo = ps.getTableInfoByName(table);
            String distSql = this.rewriteTable(this.m_srcSql, table, tableInfo.getTableAlias(), partNum);
            ArrayList conlist = null;
            conlist = tables.length <= 0 ? this.m_gsc.getDistServerList() : this.m_gsc.getDistServerList(table, partNum);
            for (int i3 = 0; i3 < conlist.size(); ++i3) {
                QueryInfo qf = new QueryInfo();
                qf.setTable(qiSrc.getTables());
                qf.setPartNo(qiSrc.getPartNo());
                qf.setSql(distSql);
                qf.setConnection((Connection)conlist.get(i3));
                this.m_info.add(qf);
            }
        } else {
            if (Driver.forestTestLog) {
                System.out.println("The query type was specified to be a partition.");
            }
            if (Driver.logInfo) {
                this.m_logUtil.info("The query type was specified to be a partition.");
            }
            this.m_queyType = 0;
            Iterator iter = qiMap.values().iterator();
            while (iter.hasNext()) {
                QueryInfo queryInfo = (QueryInfo)iter.next();
                int partNum = queryInfo.getPartNo();
                String table = tables[partTableIdx];
                Parser.TableInfo tableInfo = ps.getTableInfoByName(table);
                String distSql = this.rewriteTable(this.m_srcSql, table, tableInfo.getTableAlias(), partNum);
                Connection con = this.m_gsc.getDistServer(table, partNum);
                queryInfo.setSql(distSql);
                queryInfo.setConnection(con);
                this.m_info.add(queryInfo);
            }
        }
    }

    protected void makeInsertQuery(Parser ps) throws SQLException {
        this.m_queyType = 2;
        String insertSql = this.m_srcSql;
        String[] tables = ps.getTables();
        String tableName = tables[0];
        ArrayList conlist = null;
        if (this.m_gsc.isPartition(tableName)) {
            HashMap<Object, Object> partCol;
            int partNum = -1;
            ArrayList cols = ps.getInsertColumns();
            if (cols == null) {
                partCol = new HashMap<Object, Object>();
                ArrayList colNums = this.m_gsc.getPartCol(tableName);
                if (colNums != null) {
                    ArrayList vals = ps.getInsertValues();
                    for (int i = 0; i < colNums.size(); ++i) {
                        PartitionColumnInfo colinfo = (PartitionColumnInfo)colNums.get(i);
                        int colNum = colinfo.getNumber();
                        int valIdx = colNum - 1;
                        if (valIdx < vals.size()) {
                            partCol.put(new Integer(colNum), vals.get(valIdx));
                            continue;
                        }
                        partCol.put(new Integer(colNum), null);
                    }
                }
                partNum = this.m_gsc.getPartNo(tableName, partCol, 1);
            } else {
                partCol = new HashMap();
                ArrayList colNames = this.m_gsc.getPartCol(tableName);
                if (colNames != null) {
                    for (int i = 0; i < colNames.size(); ++i) {
                        PartitionColumnInfo colinfo = (PartitionColumnInfo)colNames.get(i);
                        String colName = colinfo.getName();
                        ParamValue value = ps.getInsertValue(colName);
                        partCol.put(colName, value);
                    }
                }
                partNum = this.m_gsc.getPartNo(tableName, partCol, 0);
            }
            insertSql = this.rewriteTable(insertSql, tableName, partNum);
            conlist = this.m_gsc.getDistServerList(tableName, partNum);
        }
        if (conlist == null) {
            conlist = this.m_gsc.getDistServerList(tableName);
        }
        for (int i = 0; i < conlist.size(); ++i) {
            QueryInfo qf = new QueryInfo();
            qf.setConnection((Connection)conlist.get(i));
            qf.setSql(insertSql);
            qf.setTable(tables);
            this.m_info.add(qf);
        }
    }

    public static String getPartitionName(String tableName, int part) {
        if (part >= 10) {
            return tableName + "_" + part;
        }
        return tableName + "_0" + part;
    }

    protected void makeTruncateQuery(Parser ps) throws SQLException {
        this.m_queyType = 2;
        String[] tables = ps.getTables();
        Object sql = null;
        HashMap<Connection, String> con2sql = new HashMap<Connection, String>();
        for (int k = 0; k < tables.length; ++k) {
            String table = tables[k];
            if (this.m_gsc.isPartition(table) || this.m_gsc.isPartition2(table)) {
                int partNum = this.m_gsc.getPartCount(table);
                for (int p = 0; p < partNum; ++p) {
                    ArrayList a = this.m_gsc.getDistServerList(table, p);
                    for (int j = 0; j < a.size(); ++j) {
                        Connection key = (Connection)a.get(j);
                        if (con2sql.containsKey(key)) {
                            String t = (String)con2sql.get(key);
                            con2sql.put(key, t + "," + ReWriter.getPartitionName(table, p));
                            continue;
                        }
                        con2sql.put(key, ReWriter.getPartitionName(table, p));
                    }
                }
                continue;
            }
            ArrayList a = this.m_gsc.getDistServerList(table);
            for (int j = 0; j < a.size(); ++j) {
                Connection key = (Connection)a.get(j);
                if (con2sql.containsKey(key)) {
                    String t = (String)con2sql.get(key);
                    con2sql.put(key, t + "," + table);
                    continue;
                }
                con2sql.put(key, table);
            }
        }
        Iterator i = con2sql.keySet().iterator();
        while (i.hasNext()) {
            Connection con = (Connection)i.next();
            String target = (String)con2sql.get(con);
            Logger.debug("TRUNCATE: con=" + con.toString());
            Logger.debug("          sql=" + target);
            QueryInfo qf = new QueryInfo();
            qf.setConnection(con);
            qf.setSql("TRUNCATE TABLE " + target);
            qf.setTable(tables);
            this.m_info.add(qf);
        }
    }

    protected void makeUpdateQuery(Parser ps) throws SQLException {
        int i;
        this.m_queyType = 2;
        String[] tables = ps.getTables();
        String tableName = tables[0];
        ArrayList conlist = null;
        String updateSql = this.m_srcSql;
        ArrayList setCols = ps.getSetColumns();
        ArrayList partCols = this.m_gsc.getPartCol(tableName);
        if (partCols != null) {
            for (i = 0; i < partCols.size(); ++i) {
                PartitionColumnInfo colinfo = (PartitionColumnInfo)partCols.get(i);
                String partCol = colinfo.getName();
                if (!setCols.contains(partCol)) continue;
                throw new PSQLException(GT.tr("The partition attribute ({0}) is specified to be the column to change.", partCol), ForestSQLState.INTERNAL_ERROR);
            }
        }
        if (this.m_gsc.isPartition(tableName)) {
            boolean canRewrite = true;
            int partNum = -1;
            HashMap cols = ps.getWhereColumns(tableName);
            ArrayList colNames = this.m_gsc.getPartCol(tableName);
            if (colNames != null) {
                if (colNames.size() == 1) {
                    PartitionColumnInfo colinfo = (PartitionColumnInfo)partCols.get(0);
                    String colName = colinfo.getName();
                    if (cols.containsKey(colName)) {
                        HashMap partCol = new HashMap();
                        ArrayList values = (ArrayList)cols.get(colName);
                        for (int j = 0; j < values.size(); ++j) {
                            partCol.put(colName, values.get(j));
                            int partNum_Wk = this.m_gsc.getPartNo(tableName, partCol, 0);
                            if (partNum == -1) {
                                partNum = partNum_Wk;
                                continue;
                            }
                            if (partNum == partNum_Wk) continue;
                            canRewrite = false;
                            break;
                        }
                    } else {
                        canRewrite = false;
                    }
                } else {
                    HashMap partCol = new HashMap();
                    for (int i2 = 0; i2 < colNames.size(); ++i2) {
                        ArrayList values;
                        PartitionColumnInfo colinfo = (PartitionColumnInfo)partCols.get(i2);
                        String colName = colinfo.getName();
                        if (cols.containsKey(colName)) {
                            values = (ArrayList)cols.get(colName);
                            if (values.size() != 1) {
                                canRewrite = false;
                                break;
                            }
                        } else {
                            canRewrite = false;
                            break;
                        }
                        partCol.put(colName, values.get(0));
                    }
                    if (canRewrite && !partCol.isEmpty()) {
                        partNum = this.m_gsc.getPartNo(tableName, partCol, 0);
                    }
                }
            }
            if (canRewrite) {
                updateSql = this.rewriteTable(updateSql, tableName, partNum);
                conlist = this.m_gsc.getDistServerList(tableName, partNum);
            } else if (this.m_gsc.isPartition2(tableName)) {
                throw new PSQLException(GT.tr("It cannot be processed in Partition table 2."), ForestSQLState.INTERNAL_ERROR);
            }
        }
        if (conlist == null) {
            conlist = this.m_gsc.getDistServerList(tableName);
        }
        for (i = 0; i < conlist.size(); ++i) {
            QueryInfo qf = new QueryInfo();
            qf.setConnection((Connection)conlist.get(i));
            qf.setSql(updateSql);
            qf.setTable(tables);
            this.m_info.add(qf);
        }
    }

    protected void makeDeleteQuery(Parser ps) throws SQLException {
        this.m_queyType = 2;
        String deleteSql = this.m_srcSql;
        String[] tables = ps.getTables();
        String tableName = tables[0];
        ArrayList conlist = null;
        if (this.m_gsc.isPartition(tableName)) {
            boolean canRewrite = true;
            int partNum = -1;
            HashMap cols = ps.getWhereColumns(tableName);
            ArrayList colNames = this.m_gsc.getPartCol(tableName);
            if (colNames != null) {
                if (colNames.size() == 1) {
                    PartitionColumnInfo colinfo = (PartitionColumnInfo)colNames.get(0);
                    String colName = colinfo.getName();
                    if (cols.containsKey(colName)) {
                        HashMap partCol = new HashMap();
                        ArrayList values = (ArrayList)cols.get(colName);
                        for (int j = 0; j < values.size(); ++j) {
                            partCol.put(colName, values.get(j));
                            int partNum_Wk = this.m_gsc.getPartNo(tableName, partCol, 0);
                            if (partNum == -1) {
                                partNum = partNum_Wk;
                                continue;
                            }
                            if (partNum == partNum_Wk) continue;
                            canRewrite = false;
                            break;
                        }
                    } else {
                        canRewrite = false;
                    }
                } else {
                    HashMap partCol = new HashMap();
                    for (int i = 0; i < colNames.size(); ++i) {
                        ArrayList values;
                        PartitionColumnInfo colinfo = (PartitionColumnInfo)colNames.get(i);
                        String colName = colinfo.getName();
                        if (cols.containsKey(colName)) {
                            values = (ArrayList)cols.get(colName);
                            if (values.size() != 1) {
                                canRewrite = false;
                                break;
                            }
                        } else {
                            canRewrite = false;
                            break;
                        }
                        partCol.put(colName, values.get(0));
                    }
                    if (canRewrite && !partCol.isEmpty()) {
                        partNum = this.m_gsc.getPartNo(tableName, partCol, 0);
                    }
                }
            }
            if (canRewrite) {
                deleteSql = this.rewriteTable(deleteSql, tableName, partNum);
                conlist = this.m_gsc.getDistServerList(tableName, partNum);
            } else if (this.m_gsc.isPartition2(tableName)) {
                throw new PSQLException(GT.tr("It cannot be processed in Partition table 2."), ForestSQLState.INTERNAL_ERROR);
            }
        }
        if (conlist == null) {
            conlist = this.m_gsc.getDistServerList(tableName);
        }
        for (int i = 0; i < conlist.size(); ++i) {
            QueryInfo qf = new QueryInfo();
            qf.setConnection((Connection)conlist.get(i));
            qf.setSql(deleteSql);
            qf.setTable(tables);
            this.m_info.add(qf);
        }
    }

    protected void makeOtherQuery() throws SQLException {
        this.m_queyType = 2;
        ArrayList conlist = this.m_gsc.getDistServerList();
        for (int i = 0; i < conlist.size(); ++i) {
            QueryInfo qf = new QueryInfo();
            qf.setConnection((Connection)conlist.get(i));
            qf.setSql(this.m_srcSql);
            this.m_info.add(qf);
        }
    }

    protected void clearSrcSql() {
        this.m_srcSql = null;
        if (this.m_info == null) {
            this.m_info = new ArrayList();
        } else {
            this.m_info.clear();
        }
        this.m_queyType = -1;
    }

    public int getQueryType() {
        return this.m_queyType;
    }

    public Connection getRetryConnection(QueryInfo info) throws SQLException {
        Connection con = null;
        if (this.m_queyType == 0) {
            int partNo = info.getPartNo();
            String[] table = info.getTables();
            for (int i = 0; i < table.length; ++i) {
                if (!this.m_gsc.isPartition(table[i])) continue;
                con = this.m_gsc.getDistServer(table[i], partNo);
                break;
            }
        } else if (this.m_queyType == 1) {
            String[] tables = info.getTables();
            con = tables == null || tables.length <= 0 ? this.m_gsc.getDistServer() : this.m_gsc.getDistServer(info.getTables());
        }
        return con;
    }

    protected String rewriteTable(String srcSql, String strTable, int nPartNo) throws SQLException {
        return this.rewriteTable(srcSql, strTable, null, nPartNo);
    }

    protected String rewriteTable(String srcSql, String strTable, String strAlias, int nPartNo) throws SQLException {
        String newTable = strTable + "_" + m_dcFmt.format(nPartNo);
        StringBuffer distSql = new StringBuffer();
        StringReader fr = new StringReader(srcSql);
        StreamTokenizer tokenizer = new StreamTokenizer(fr);
        tokenizer.resetSyntax();
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(95, 95);
        tokenizer.wordChars(42, 42);
        tokenizer.wordChars(48, 57);
        try {
            int token;
            boolean isQuoteChar = false;
            block6: while ((token = tokenizer.nextToken()) != -1) {
                switch (token) {
                    case -3: {
                        if (!isQuoteChar && strTable.equalsIgnoreCase(tokenizer.sval)) {
                            if (strAlias != null) {
                                distSql.append(this.rewriteAliasTable(tokenizer, strTable, newTable, strAlias));
                                continue block6;
                            }
                            distSql.append(newTable);
                            continue block6;
                        }
                        distSql.append(tokenizer.sval);
                        continue block6;
                    }
                    case 39: {
                        if (isQuoteChar && distSql.substring(distSql.length() - 1).equals("\\")) {
                            distSql.append((char)tokenizer.ttype);
                            continue block6;
                        }
                        isQuoteChar = !isQuoteChar;
                    }
                }
                distSql.append((char)tokenizer.ttype);
            }
        }
        catch (IOException e) {
            throw new PSQLException(GT.tr("SQL conversion error"), ForestSQLState.INTERNAL_ERROR, (Throwable)e);
        }
        return distSql.toString();
    }

    protected String rewriteAliasTable(StreamTokenizer tokenizer, String strTable, String newTable, String strAlias) throws SQLException {
        StringBuffer distSql = new StringBuffer();
        try {
            int token;
            while ((token = tokenizer.nextToken()) != -1) {
                if (token == -3) {
                    String word = tokenizer.sval;
                    if (strAlias.equals(word)) {
                        distSql.insert(0, newTable);
                    } else {
                        if (word.equalsIgnoreCase("AS")) {
                            distSql.append(word);
                            continue;
                        }
                        distSql.insert(0, strTable);
                    }
                    distSql.append(word);
                } else {
                    distSql.append((char)tokenizer.ttype);
                    if (token != 44) continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new PSQLException(GT.tr("SQL conversion error"), ForestSQLState.INTERNAL_ERROR, (Throwable)e);
        }
        return distSql.toString();
    }
}

