/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class Unicode {
    private String url;
    private String user;
    private String password;

    private static void usage() {
        Unicode.log("usage: example.Unicode <url> <user> <password>");
    }

    private static void log(String message) {
        System.err.println(message);
    }

    private static void log(String message, Exception e) {
        System.err.println(message);
        e.printStackTrace();
    }

    public Unicode(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
    }

    private Connection getConnection() throws SQLException, ClassNotFoundException {
        Class.forName("org.postgresforest.Driver");
        Properties info = new Properties();
        info.put("user", this.user);
        info.put("password", this.password);
        info.put("charSet", "utf-8");
        return DriverManager.getConnection(this.url, info);
    }

    private String getSqlSafeUnicodeBlock(int blockNum) {
        if (blockNum < 0 || blockNum > 255) {
            throw new IllegalArgumentException("blockNum must be from 0 to 255: " + blockNum);
        }
        StringBuffer sb = new StringBuffer(256);
        int blockFirst = blockNum * 256;
        int blockLast = blockFirst + 256;
        for (int i = blockFirst; i < blockLast; ++i) {
            char c = (char)i;
            if (c == '\u0000' || c == '\'' || c == '\\') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private boolean isValidUnicodeBlock(int blockNum) {
        return blockNum < 216 || blockNum > 219;
    }

    private void reportRetrievalError(int blockNum, String block, String retrieved) {
        String message = "Block " + blockNum + " returned incorrectly: ";
        int i = 0;
        for (i = 0; i < block.length(); ++i) {
            if (i >= retrieved.length()) {
                message = message + "too short";
                break;
            }
            if (retrieved.charAt(i) == block.charAt(i)) continue;
            message = message + "first changed character at position " + i + ", sent as 0x" + Integer.toHexString(block.charAt(i)) + ", retrieved as 0x" + Integer.toHexString(retrieved.charAt(i));
            break;
        }
        if (i >= block.length()) {
            message = message + "too long";
        }
        Unicode.log(message);
    }

    public void runTest() {
        Connection connection = null;
        Statement statement = null;
        int blockNum = 0;
        boolean CREATE = false;
        boolean INSERT = true;
        int SELECT = 2;
        int LIKE = 3;
        int mode = 0;
        try {
            String block;
            connection = this.getConnection();
            statement = connection.createStatement();
            statement.executeUpdate("CREATE TABLE test_unicode ( blockNum INT PRIMARY KEY, block TEXT );");
            mode = 1;
            for (blockNum = 0; blockNum < 256; ++blockNum) {
                if (!this.isValidUnicodeBlock(blockNum)) continue;
                block = this.getSqlSafeUnicodeBlock(blockNum);
                statement.executeUpdate("INSERT INTO test_unicode VALUES ( " + blockNum + ", '" + block + "');");
            }
            mode = 2;
            for (blockNum = 0; blockNum < 256; ++blockNum) {
                if (!this.isValidUnicodeBlock(blockNum)) continue;
                block = this.getSqlSafeUnicodeBlock(blockNum);
                ResultSet rs = statement.executeQuery("SELECT block FROM test_unicode WHERE blockNum = " + blockNum + ";");
                if (!rs.next()) {
                    Unicode.log("Could not retrieve block " + blockNum);
                    continue;
                }
                String retrieved = rs.getString(1);
                if (retrieved.equals(block)) continue;
                this.reportRetrievalError(blockNum, block, retrieved);
            }
            mode = 3;
            for (blockNum = 0; blockNum < 256; ++blockNum) {
                if (!this.isValidUnicodeBlock(blockNum)) continue;
                block = this.getSqlSafeUnicodeBlock(blockNum);
                String likeString = "%" + block.substring(2, block.length() - 3) + "%";
                ResultSet rs = statement.executeQuery("SELECT blockNum FROM test_unicode WHERE block LIKE '" + likeString + "';");
                if (rs.next()) continue;
                Unicode.log("Could get block " + blockNum + " using LIKE");
            }
        }
        catch (SQLException sqle) {
            switch (mode) {
                case 0: {
                    Unicode.log("Exception creating database", sqle);
                    break;
                }
                case 1: {
                    Unicode.log("Exception inserting block " + blockNum, sqle);
                    break;
                }
                case 2: {
                    Unicode.log("Exception selecting block " + blockNum, sqle);
                    break;
                }
                case 3: {
                    Unicode.log("Exception doing LIKE on block " + blockNum, sqle);
                    break;
                }
                default: {
                    Unicode.log("Exception", sqle);
                    break;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            Unicode.log("Unable to load driver", cnfe);
            return;
        }
        try {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sqle) {
            Unicode.log("Exception closing connections", sqle);
        }
        if (mode > 0) {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                statement.executeUpdate("DROP TABLE test_unicode;");
            }
            catch (Exception sqle) {
                Unicode.log("*** ERROR: unable to delete test table test_unicode; must be deleted manually", sqle);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            Unicode.usage();
            System.exit(1);
        }
        new Unicode(args[0], args[1], args[2]).runTest();
    }
}

