/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.lib;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import org.postgresforest.tool.ArrayUtil;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GSCdata;

public class Instance {
    GSCdata gsc = null;
    int id = -1;
    String hostName = null;
    String portNumber = null;
    int status = -1;
    Connection con = null;

    public Instance(GSCdata gsc, String hostName, String portNumber) {
        this(gsc, -1, hostName, portNumber);
    }

    public Instance(GSCdata gsc, int id, String hostName, String portNumber) {
        this.gsc = gsc;
        this.id = id;
        this.hostName = hostName;
        this.portNumber = portNumber;
    }

    protected Connection getDatabaseConnection(String dbName, String user, String pass) throws ForestToolException {
        Connection con = null;
        try {
            Class.forName("org.postgresql.Driver");
            con = DriverManager.getConnection("jdbc:postgresql://" + this.hostName + ":" + this.portNumber + "/" + dbName, user, pass);
            Logger.debug("connected: jdbc:postgresql://" + this.hostName + ":" + this.portNumber + "/" + dbName);
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        return con;
    }

    public int getId() {
        return this.id;
    }

    public boolean setId(int id) {
        this.id = id;
        return this.setParam("serverid", id);
    }

    public String getHostName() {
        String url = this.getParam("url");
        if (url != null) {
            this.hostName = url.substring(2, url.indexOf(58));
        }
        return this.hostName;
    }

    public boolean setHostName(String hostName) {
        this.hostName = hostName;
        return this.setParam("url", "//" + hostName + ":" + this.portNumber + "/");
    }

    public String getPortNumber() {
        String url = this.getParam("url");
        if (url != null) {
            this.portNumber = url.substring(url.indexOf(58) + 1, url.length() - 1);
        }
        return this.portNumber;
    }

    public boolean setPortNumber(String portNumber) {
        this.portNumber = portNumber;
        return this.setParam("url", "//" + this.hostName + ":" + portNumber + "/");
    }

    public int getStatus() {
        return Integer.parseInt(this.getParam("status"));
    }

    public boolean setStatus(int status) {
        if (status != 1 && status != -1) {
            return false;
        }
        this.status = status;
        return this.setParam("status", status);
    }

    public boolean createDatabase(String dbName) throws ForestToolException {
        return this.createDatabase(dbName, null);
    }

    public boolean createDatabase(String dbName, String option) throws ForestToolException {
        dbName = dbName.toLowerCase();
        try {
            String url = "jdbc:postgresql://" + this.hostName + ":" + this.portNumber + "/" + "postgres";
            this.con = DriverManager.getConnection(url, this.gsc.getUser(), this.gsc.getPassword());
            String sql = "CREATE DATABASE " + dbName + " WITH TEMPLATE forest_template ";
            if (option != null) {
                sql = sql + option;
            }
            Logger.debug("createDatabase: " + sql);
            Statement stmt = this.con.createStatement();
            int rc = stmt.executeUpdate(sql);
            this.con.commit();
            this.con.close();
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        return true;
    }

    public String[] getDatabaseNames() {
        String sql = "SELECT dbname FROM forest_servdb WHERE serverid=" + this.id;
        ArrayList<String> a = new ArrayList<String>();
        try {
            ResultSet rs = this.gsc.executeQueryGSC(sql);
            while (rs.next()) {
                a.add(rs.getString(1));
            }
            rs.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
        return ArrayUtil.array2stringarray(a);
    }

    public String toString() {
        return "Instance[" + this.id + "] " + this.hostName + ":" + this.portNumber;
    }

    private boolean setParam(String param, int value) {
        return this.setParam(param, "" + value);
    }

    private boolean setParam(String param, String value) {
        if (this.id < 0) {
            Logger.debug("Instance#setParam(): serverid is negative. - " + this.toString());
            return false;
        }
        try {
            int rc = this.gsc.executeUpdateGSC("UPDATE forest_server SET " + param + "='" + value + "' " + " WHERE serverid=" + this.id);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            return false;
        }
        return true;
    }

    private String getParam(String param) {
        String value = null;
        if (this.id < 0) {
            Logger.debug("Instance#setParam(): serverid is negative. - " + this.toString());
            return null;
        }
        try {
            ResultSet rs = null;
            rs = this.gsc.executeQueryGSC("SELECT " + param + " FROM forest_server " + " WHERE serverid=" + this.id);
            if (rs.next()) {
                value = rs.getString(1);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            return null;
        }
        return value;
    }

    public boolean dropDatabase(String dbName) {
        try {
            Connection con = this.getDatabaseConnection("postgres", this.gsc.getUser(), this.gsc.getPassword());
            Statement stmt = con.createStatement();
            stmt.executeUpdate("DROP DATABASE " + dbName);
            con.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return false;
        }
        return true;
    }

    public String[] getGscNames() {
        return null;
    }
}

