/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.lib;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.postgresforest.tool.ArrayUtil;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.BrokenLog;
import org.postgresforest.tool.lib.ByteaUtils;
import org.postgresforest.tool.lib.Config;
import org.postgresforest.tool.lib.Database;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.HashInfo;
import org.postgresforest.tool.lib.Instance;

public class GSCdata {
    int serverId = 0;
    String user = null;
    String pass = null;
    String gscName = null;
    String hostName = null;
    String portNumber = null;
    Connection master = null;
    ArrayList otherGSC = null;
    public static final int VALIDATE_SCHEMA = 1;
    public static final int VALIDATE_RECORD_COUNT = 2;
    public static final int VALIDATE_RECORD_COMPARE = 4;
    public static final String TemplateDatabase = "postgres";

    public static GSCdata initialize(String hostName, String portNumber, String gscName, String user, String pass) throws ForestToolException {
        Object url = null;
        Connection con = null;
        Statement stmt = null;
        try {
            con = GSCdata.createEmptyGSC(hostName, portNumber, gscName, user, pass);
            stmt = con.createStatement();
            String u = "//" + hostName + ":" + portNumber + "/";
            String q = "INSERT INTO forest_server (serverid, url, status)  VALUES (0, '" + u + "', 1)";
            int rc = stmt.executeUpdate(q);
            q = "INSERT INTO forest_gsc (serverid, dbname) VALUES (0, '" + gscName + "')";
            rc = stmt.executeUpdate(q);
            con.commit();
            stmt.close();
        }
        catch (SQLException e) {
            Logger.debug(e.getMessage());
            Logger.trace(e);
            throw new ForestToolException(e);
        }
        try {
            con.close();
        }
        catch (Exception e) {
            Logger.warning("Exception while closing connection is going to be ignored.");
            Logger.debug(e.getMessage());
            Logger.trace(e);
        }
        GSCdata gsc = new GSCdata(hostName, portNumber, gscName, user, pass);
        Config tmpconfig = new Config(gsc, "FOREST_DEFAULT_CONFIG");
        Config config = gsc.createConfig("FOREST_DEFAULT_CONFIG", tmpconfig);
        if (config == null) {
            Logger.error("Can't create FOREST_DEFAULT_CONFIG while initializing.");
        }
        return gsc;
    }

    protected static Connection createEmptyGSC(String hostName, String portNumber, String gscName, String user, String pass) throws ForestToolException {
        String url = null;
        Connection con = null;
        Statement stmt = null;
        try {
            String tmpurl = "jdbc:postgresql://" + hostName + ":" + portNumber + "/" + TemplateDatabase;
            con = GSCdata.connectdb(tmpurl, user, pass);
            con.setAutoCommit(true);
            stmt = con.createStatement();
            int rc = stmt.executeUpdate("CREATE DATABASE " + gscName);
            con.close();
            url = "jdbc:postgresql://" + hostName + ":" + portNumber + "/" + gscName;
            con = GSCdata.connectdb(url, user, pass);
            stmt = con.createStatement();
            rc = stmt.executeUpdate(GSCdata.getGscSchemaDefs());
            con.commit();
            stmt.close();
        }
        catch (SQLException e) {
            Logger.debug(e.getMessage());
            Logger.trace(e);
            throw new ForestToolException("GSC\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093.", e);
        }
        return con;
    }

    public GSCdata(String hostName, String portNumber, String gscName, String user, String pass) throws ForestToolException {
        String url = "//" + hostName + ":" + portNumber + "/";
        String full_url = "jdbc:postgresql:" + url + gscName;
        try {
            this.open(hostName, portNumber, gscName, user, pass);
        }
        catch (Exception e) {
            throw new ForestToolException("Can't connect to the GSC.", e);
        }
        this.gscName = gscName;
        this.hostName = hostName;
        this.portNumber = portNumber;
        this.user = user;
        this.pass = pass;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.pass;
    }

    public Config createConfig(String configName) {
        Config config = this.getConfig("FOREST_DEFAULT_CONFIG");
        return this.createConfig(configName, config);
    }

    public Config createConfig(String configName, String desc, int cache_refresh, int retry_count, int defect_timeout, int distributed_connection, int partition_mode, int synchronize_mode) {
        Config config = new Config(this, configName, desc, cache_refresh, retry_count, defect_timeout, distributed_connection, partition_mode, synchronize_mode);
        return this.createConfig(config.getId(), config);
    }

    public Config createConfig(String configName, String sourceConfigName) {
        return this.createConfig(configName, new Config(this, sourceConfigName));
    }

    public Config createConfig(String configName, Config sourceConfig) {
        String sql = "INSERT INTO forest_config(configid,description,cache_reflesh,retry_count,defect_timeout,distributed_connection,pertition_mode,syncronize_mode,update_date) VALUES ('" + configName + "'," + "'" + sourceConfig.getDescription() + "'," + "" + sourceConfig.getCacheRefresh() + "," + "" + sourceConfig.getRetryCount() + "," + "" + sourceConfig.getDefectTimeout() + "," + "" + sourceConfig.getDistributedConnection() + "," + "" + sourceConfig.getPartitionMode() + "," + "" + sourceConfig.getSynchronizeMode() + "," + "now())";
        int rc = 0;
        rc = this.executeUpdateGSC(sql);
        if (rc > 0) {
            return this.getConfig(configName);
        }
        return null;
    }

    public String[] getConfigNames() throws ForestToolException {
        ArrayList<String> a = new ArrayList<String>();
        try {
            ResultSet rs = this.executeQueryGSC("SELECT configid FROM forest_config ORDER BY configid");
            while (rs.next()) {
                a.add(rs.getString(1));
            }
            rs.close();
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        return ArrayUtil.array2stringarray(a);
    }

    public Config getConfig(String configName) {
        String sql = "SELECT configid,description,cache_reflesh,retry_count,defect_timeout,distributed_connection,pertition_mode,syncronize_mode,update_date FROM forest_config WHERE configid='" + configName + "'";
        ResultSet rs = null;
        try {
            rs = this.executeQueryGSC(sql);
        }
        catch (Exception e) {
            Logger.error("Can't get CONFIG entry. [" + configName + "]");
            Logger.error(e.getMessage());
            return null;
        }
        Config config = null;
        try {
            if (rs.next()) {
                config = new Config(this, configName, rs.getString("description"), rs.getInt("cache_reflesh"), rs.getInt("retry_count"), rs.getInt("defect_timeout"), rs.getInt("distributed_connection"), rs.getInt("pertition_mode"), rs.getInt("syncronize_mode"));
            }
        }
        catch (Exception e) {
            Logger.error("Can't build Config object. / " + configName);
            return null;
        }
        return config;
    }

    public boolean dropConfig(String configId) {
        String sql = "DELETE FROM forest_config WHERE configid='" + configId + "'";
        boolean result = false;
        try {
            int rc = this.executeUpdateGSC(sql);
            if (rc > 0) {
                result = true;
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            result = false;
        }
        return result;
    }

    public boolean dropConfig(Config config) {
        if (config == null) {
            return false;
        }
        return this.dropConfig(config.getId());
    }

    public Instance registerInstance(String hostName, String portNumber) {
        int serverId = -1;
        if (hostName == null || portNumber == null) {
            return null;
        }
        try {
            ResultSet rs = this.executeQueryGSC("SELECT max(serverid) FROM forest_server");
            rs.next();
            serverId = rs.getInt(1);
            rs.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            return null;
        }
        String url = "//" + hostName + ":" + portNumber + "/";
        String sql = "INSERT INTO forest_server(serverid,url,status) VALUES (" + ++serverId + "," + "'" + url + "'," + "" + -1 + ")";
        int rc = this.executeUpdateGSC(sql);
        return this.getInstance(serverId);
    }

    public int[] getInstanceIds() throws ForestToolException {
        ArrayList<Integer> a = new ArrayList<Integer>();
        try {
            ResultSet rs = this.executeQueryGSC("SELECT serverid FROM forest_server ORDER BY serverid");
            while (rs.next()) {
                a.add(new Integer(rs.getInt(1)));
            }
            rs.close();
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        return ArrayUtil.array2intarray(a);
    }

    public Instance getInstance(int serverid) {
        int serverId = -1;
        String url = null;
        int status = -1;
        try {
            ResultSet rs = this.executeQueryGSC("SELECT url,status FROM forest_server WHERE serverid=" + serverid);
            if (!rs.next()) {
                return null;
            }
            url = rs.getString(1);
            status = rs.getInt(2);
            rs.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return null;
        }
        String tmp = url.substring(2, url.length() - 1);
        String host = tmp.substring(0, tmp.indexOf(":"));
        String port = tmp.substring(tmp.indexOf(":") + 1);
        Instance instance = new Instance(this, serverid, host, port);
        return instance;
    }

    public boolean unregisterInstance(Instance instance) {
        if (instance == null) {
            return false;
        }
        return this.unregisterInstance(instance.getId());
    }

    public boolean unregisterInstance(int instanceId) {
        return this.unregisterInstance(instanceId, false);
    }

    public boolean unregisterInstance(int instanceId, boolean force) {
        Instance ins = this.getInstance(instanceId);
        if (ins == null) {
            return false;
        }
        String[] dbNames = ins.getDatabaseNames();
        if (dbNames.length > 0) {
            if (force) {
                Logger.notice("Existing database(s) will be dropped.");
                for (int i = 0; i < dbNames.length; ++i) {
                    if (this.dropDatabase(dbNames[i], instanceId, true)) continue;
                    return false;
                }
            } else {
                Logger.error("Instance has some user objects. Please drop them before unregister the instance.");
                return false;
            }
        }
        try {
            String sql = "DELETE FROM forest_server WHERE serverid=" + instanceId;
            int rc = this.executeUpdateGSC(sql);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return false;
        }
        return true;
    }

    public Database createDatabase(String dbName) throws ForestToolException {
        return this.createDatabase(this.getInstanceIds(), dbName);
    }

    public Database createDatabase(String dbName, String option) throws ForestToolException {
        return this.createDatabase(this.getInstanceIds(), dbName, option);
    }

    public Database createDatabase(int[] instanceIds, String dbName) throws ForestToolException {
        return this.createDatabase(instanceIds, dbName, null);
    }

    public Database createDatabase(int[] instanceIds, String dbName, String option) throws ForestToolException {
        Database d = null;
        try {
            for (int i = 0; i < instanceIds.length; ++i) {
                Instance instance = this.getInstance(instanceIds[i]);
                if (instance == null) {
                    Logger.error("NullPointerException: instanceId=" + instanceIds[i]);
                }
                instance.createDatabase(dbName, option);
                String sql = "INSERT INTO forest_servdb(dbno,dbname,serverid) VALUES (" + i + ",'" + dbName + "'," + instanceIds[i] + ")";
                int rc = this.executeUpdateGSC(sql);
                d = new Database(this, instanceIds, dbName);
            }
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        return d;
    }

    public String[] getDatabaseNames() throws ForestToolException {
        String sql = "SELECT dbname FROM forest_servdb GROUP BY dbname ORDER BY dbname";
        ArrayList<String> a = new ArrayList<String>();
        try {
            ResultSet rs = this.executeQueryGSC(sql);
            while (rs.next()) {
                a.add(rs.getString("dbname"));
            }
            rs.close();
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        return ArrayUtil.array2stringarray(a);
    }

    public Database getDatabase(String dbName) throws ForestToolException {
        String sql = "SELECT serverid FROM forest_servdb WHERE dbname='" + dbName + "' ORDER BY serverid";
        ArrayList<Integer> a = new ArrayList<Integer>();
        try {
            ResultSet rs = this.executeQueryGSC(sql);
            while (rs.next()) {
                int serverid = rs.getInt("serverid");
                a.add(new Integer(serverid));
            }
            if (a.size() == 0) {
                return null;
            }
            rs.close();
        }
        catch (Exception e) {
            throw new ForestToolException(e);
        }
        return new Database(this, ArrayUtil.array2intarray(a), dbName);
    }

    public boolean dropDatabase(Database db) {
        return this.dropDatabase(db.getDatabaseName(), false);
    }

    public boolean dropDatabase(String dbName) {
        return this.dropDatabase(dbName, false);
    }

    public boolean dropDatabase(Database db, boolean force) {
        return this.dropDatabase(db.getDatabaseName(), force);
    }

    public boolean dropDatabase(String dbName, boolean force) {
        Database db = null;
        try {
            db = this.getDatabase(dbName);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return false;
        }
        int[] instanceIds = db.getInstanceIds();
        for (int i = 0; i < instanceIds.length; ++i) {
            if (this.dropDatabase(dbName, instanceIds[i], force)) continue;
            return false;
        }
        return true;
    }

    public boolean dropDatabase(String dbName, int instanceId) {
        return this.dropDatabase(dbName, instanceId, false);
    }

    public boolean dropDatabase(String dbName, int instanceId, boolean force) {
        String sql = null;
        boolean hasObject = false;
        try {
            sql = "SELECT count(t.table_name) FROM forest_servdb s, forest_tablepartdtl t  WHERE s.dbname='" + dbName + "' AND s.serverid=" + instanceId + " AND s.dbno=t.dbno";
            ResultSet rs = this.executeQueryGSC(sql);
            if (rs.next() && rs.getInt(1) > 0) {
                hasObject = true;
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return false;
        }
        if (hasObject && !force) {
            Logger.warning("Database has some user objects. Please drop them before dropping the database.");
            return false;
        }
        try {
            sql = "DELETE FROM forest_tablepartdtl WHERE dbname='" + dbName + "' " + "   AND dbno = ( SELECT dbno FROM forest_servdb " + "                 WHERE serverid=" + instanceId + " AND dbname='" + dbName + "' );";
            sql = sql + "DELETE FROM forest_servdb WHERE dbname='" + dbName + "' AND serverid=" + instanceId + ";";
            int rc = this.executeUpdateGSC(sql);
            sql = "SELECT count(*) FROM forest_servdb WHERE dbname='" + dbName + "';";
            ResultSet rs = this.executeQueryGSC(sql);
            if (rs.next() && rs.getInt(1) == 0) {
                sql = "DELETE FROM forest_partatr WHERE dbname='" + dbName + "';";
                sql = sql + "DELETE FROM forest_tablepart WHERE dbname='" + dbName + "';";
                rc = this.executeUpdateGSC(sql);
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return false;
        }
        Instance ins = this.getInstance(instanceId);
        return ins.dropDatabase(dbName);
    }

    private static Connection connectdb(String host, String port, String db, String user, String pass) throws SQLException, ForestToolException {
        String url = "jdbc:postgresql://" + host + ":" + port + "/" + db;
        return GSCdata.connectdb(url, user, pass);
    }

    private static Connection connectdb(String url, String user, String pass) throws SQLException, ForestToolException {
        Connection con = null;
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            throw new ForestToolException(e);
        }
        con = DriverManager.getConnection(url, user, pass);
        Logger.debug("Connected: " + url + ", " + user + ", " + con.toString());
        con.setAutoCommit(false);
        return con;
    }

    public void open(String hostName, String portNumber, String gscName, String user, String pass) throws SQLException, ForestToolException {
        this.master = GSCdata.connectdb(hostName, portNumber, gscName, user, pass);
        this.otherGSC = new ArrayList();
        Statement stmt = this.master.createStatement();
        String q = "SELECT s.serverid,s.url,g.dbname   FROM forest_gsc g, forest_server s  WHERE g.serverid=s.serverid";
        ResultSet rs = stmt.executeQuery(q);
        String url = "//" + hostName + ":" + portNumber + "/";
        while (rs != null && rs.next()) {
            if (rs.getString(2).equals(url)) {
                this.serverId = Integer.parseInt(rs.getString(1));
                Logger.debug("open(): my serverid = " + this.serverId);
                continue;
            }
            String uu = rs.getString(2);
            String gg = rs.getString(3);
            String full_url = "jdbc:postgresql:" + uu + gg;
            Logger.debug("GSC: " + full_url);
            this.otherGSC.add(full_url);
        }
        if (rs != null) {
            rs.close();
        }
    }

    public void close() throws ForestToolException {
        try {
            this.master.close();
        }
        catch (SQLException e) {
            Logger.debug(e.getMessage());
            Logger.trace(e);
            throw new ForestToolException(e);
        }
    }

    protected static String getGscSchemaDefs() {
        String defs = "";
        defs = defs + "CREATE TABLE forest_server (" + "serverid        INT2 NOT NULL, " + "url             VARCHAR(64) NOT NULL, " + "status          INT2 NOT NULL, " + "CONSTRAINT p_key_forest_server PRIMARY KEY(serverid), " + "CONSTRAINT u_key_forest_server UNIQUE(url) " + ");";
        defs = defs + "CREATE TABLE forest_gsc ( " + "serverid        INT2 NOT NULL, " + "dbname          NAME NOT NULL, " + "CONSTRAINT p_key_forest_gsc PRIMARY KEY(serverid,dbname), " + "CONSTRAINT f_key_forest_gsc_server FOREIGN KEY(serverid) REFERENCES forest_server(serverid) DEFERRABLE " + ");";
        defs = defs + "CREATE TABLE forest_servdb ( " + "dbno            INT2 NOT NULL, " + "dbname          NAME NOT NULL, " + "serverid        INT2 NOT NULL, " + "CONSTRAINT p_key_forest_servdb PRIMARY KEY(dbno,dbname), " + "CONSTRAINT u_key_forest_servdb UNIQUE(serverid,dbname), " + "CONSTRAINT f_key_forest_servdb_server FOREIGN KEY(serverid) REFERENCES forest_server(serverid) DEFERRABLE " + ");";
        defs = defs + "CREATE TABLE forest_hash ( " + "name         VARCHAR(256) , " + "description  TEXT , " + "class        bytea, " + "CONSTRAINT p_key_forest_hash PRIMARY KEY(name) " + ");";
        defs = defs + "CREATE TABLE forest_tablepart ( " + "dbname          NAME NOT NULL, " + "table_name      NAME NOT NULL, " + "part_count      INT2 NOT NULL, " + "part_type       INT2 NOT NULL, " + "hash_name       VARCHAR(256), " + "status          INT2 DEFAULT '0' NOT NULL , " + "CONSTRAINT p_key_forest_tablepart PRIMARY KEY(dbname,table_name), " + "CONSTRAINT f_key_forest_tablepart_hash FOREIGN KEY(hash_name) REFERENCES forest_hash(name) DEFERRABLE " + ");";
        defs = defs + "CREATE TABLE forest_tablepartdtl ( " + "dbno            INT2 NOT NULL, " + "dbname          NAME NOT NULL, " + "table_name      NAME NOT NULL, " + "part_no         INT2 NOT NULL, " + "priority        INT2 NOT NULL, " + "CONSTRAINT p_key_forest_tablepartdtl PRIMARY KEY(dbno,dbname,table_name,part_no), " + "CONSTRAINT f_key_forest_tablepartdtl_servdb FOREIGN KEY(dbno,dbname) REFERENCES forest_servdb(dbno,dbname) DEFERRABLE," + "CONSTRAINT f_key_forest_tablepartdtl_tablepart FOREIGN KEY(dbname,table_name) REFERENCES forest_tablepart(dbname,table_name) DEFERRABLE " + ");";
        defs = defs + "CREATE TABLE forest_partatr ( " + "dbname          NAME NOT NULL, " + "table_name      NAME NOT NULL, " + "column_name     NAME NOT NULL, " + "column_no       INT2 NOT NULL, " + "column_type     NAME NOT NULL, " + "CONSTRAINT p_key_forest_partatr PRIMARY KEY(dbname,table_name,column_name), " + "CONSTRAINT f_key_forest_partatr_tablepart FOREIGN KEY(dbname,table_name) REFERENCES forest_tablepart(dbname,table_name) DEFERRABLE " + ");";
        defs = defs + "CREATE TABLE forest_brokenlog ( " + "serverid       INT2 NOT NULL, " + "datetime       TIMESTAMP, " + "client         VARCHAR(64) , " + "msg            TEXT, " + "status         TEXT, " + "query          TEXT, " + "CONSTRAINT f_key_forest_brokenlog_server FOREIGN KEY(serverid) REFERENCES forest_server(serverid) DEFERRABLE " + ");";
        defs = defs + "CREATE TABLE forest_config ( " + "configid        VARCHAR(256) , " + "description     TEXT         , " + "cache_reflesh           INT2 , " + "retry_count             INT2 , " + "defect_timeout          INT2 , " + "distributed_connection  INT2 , " + "pertition_mode          INT2 , " + "syncronize_mode         INT2, " + "update_date     TIMESTAMP  NOT NULL, " + "CONSTRAINT p_key_forest_config PRIMARY KEY(configid) " + ");";
        defs = defs + "REVOKE ALL ON TABLE forest_server,forest_gsc,forest_servdb,forest_hash,forest_tablepart,forest_tablepartdtl,forest_partatr,forest_brokenlog,forest_config FROM public;";
        defs = defs + "GRANT SELECT ON TABLE forest_server,forest_gsc,forest_servdb,forest_hash,forest_tablepart,forest_tablepartdtl,forest_partatr,forest_brokenlog,forest_config TO public;";
        defs = defs + "GRANT UPDATE ON TABLE forest_server,forest_config TO public;";
        defs = defs + "GRANT INSERT ON TABLE forest_brokenlog TO public;";
        return defs;
    }

    protected ResultSet executeQueryGSC(String sql) throws ForestToolException {
        ResultSet rs = null;
        Logger.debug("GSC: " + sql);
        try {
            Statement stmt = this.master.createStatement();
            rs = stmt.executeQuery(sql);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            rs = null;
            throw new ForestToolException(e);
        }
        return rs;
    }

    protected ArrayList connectOthers() {
        ArrayList<Connection> a = new ArrayList<Connection>();
        for (int i = 0; i < this.otherGSC.size(); ++i) {
            String url = (String)this.otherGSC.get(i);
            try {
                a.add(GSCdata.connectdb(url, this.getUser(), this.getPassword()));
                continue;
            }
            catch (Exception e) {
                Logger.warning("Exception caught while opening GSC connection, but ignored.");
                Logger.error(e.getMessage());
                Logger.trace(e);
            }
        }
        return a;
    }

    protected void closeOthers(ArrayList a) {
        for (int i = 0; i < a.size(); ++i) {
            Connection con = (Connection)a.get(i);
            try {
                con.close();
                continue;
            }
            catch (SQLException e) {
                Logger.warning("Exception caught while closing GSC connection, but ignored.");
                Logger.error(e.getMessage());
                Logger.trace(e);
            }
        }
    }

    protected int executeUpdateGSC(String sql) {
        int updates = 0;
        int rc = 0;
        try {
            this.master.setAutoCommit(false);
            Statement stmt = this.master.createStatement();
            Logger.debug("GSC: " + sql);
            stmt.executeUpdate("SET CONSTRAINTS ALL DEFERRED;");
            rc = stmt.executeUpdate(sql);
            stmt.close();
            this.master.commit();
            if (rc > 0) {
                ++updates;
            }
        }
        catch (Exception e) {
            Logger.error("Could not update the master GSC.");
            Logger.error(e.getMessage());
            Logger.trace(e);
            this.rollbackWithoutError(this.master);
            return updates;
        }
        ArrayList a = this.connectOthers();
        for (int i = 0; i < a.size(); ++i) {
            Connection con = null;
            try {
                con = (Connection)a.get(i);
                con.setAutoCommit(false);
                Statement stmt = con.createStatement();
                Logger.debug("GSC: " + sql);
                stmt.executeUpdate("SET CONSTRAINTS ALL DEFERRED;");
                int rc2 = stmt.executeUpdate(sql);
                stmt.close();
                if (rc != rc2) {
                    Logger.warning("Dangerous update detected while updating GSC(s).");
                    Logger.warning("  rc=" + rc + ",rc2=" + rc2);
                }
                con.commit();
                if (rc2 <= 0) continue;
                ++updates;
                continue;
            }
            catch (Exception e) {
                Logger.warning("Exception going to be ignored while updating GSC(s).");
                Logger.warning(e.getMessage());
                Logger.trace(e);
                this.rollbackWithoutError(con);
            }
        }
        this.closeOthers(a);
        return updates;
    }

    public HashInfo getHash(String hashName) {
        HashInfo hash = null;
        try {
            ResultSet rs = this.executeQueryGSC("SELECT description,class FROM forest_hash  WHERE name='" + hashName + "'");
            if (rs.next()) {
                hash = new HashInfo(hashName, rs.getString(1), rs.getBytes(2));
            }
            rs.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
        }
        return hash;
    }

    public String[] getHashNames() {
        ArrayList<String> a = new ArrayList<String>();
        try {
            ResultSet rs = this.executeQueryGSC("SELECT name FROM forest_hash ORDER BY name");
            while (rs.next()) {
                a.add(rs.getString(1));
            }
            rs.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
        }
        return ArrayUtil.array2stringarray(a);
    }

    public boolean registerHash(String hashName, String desc, byte[] classImage) {
        boolean result = false;
        try {
            String classImageS = ByteaUtils.encodeBytes(classImage);
            String sql = "INSERT INTO forest_hash(name,description,class) VALUES ('" + hashName + "'," + "'" + desc + "'," + "'" + classImageS + "')";
            int rc = this.executeUpdateGSC(sql);
            if (rc > 0) {
                result = true;
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
        }
        return result;
    }

    public boolean unregisterHash(String hashName) {
        boolean result = false;
        try {
            int rc = this.executeUpdateGSC("DELETE FROM forest_hash WHERE name='" + hashName + "'");
            if (rc > 0) {
                result = true;
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
        }
        return result;
    }

    public String getGscName() {
        return this.gscName;
    }

    public boolean copy(Instance target) {
        return this.copy(target, false);
    }

    public boolean copy(Instance target, boolean force) {
        if (target == null) {
            return false;
        }
        if (force) {
            this.drop(target);
        }
        return this._copy(target);
    }

    private boolean _copy(Instance target) {
        Connection con = null;
        try {
            con = GSCdata.createEmptyGSC(target.getHostName(), target.getPortNumber(), this.getGscName(), this.getUser(), this.getPassword());
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            this.closeWithoutError(con);
            return false;
        }
        String tableName = null;
        String[] columnNames = null;
        int[] colTypes = null;
        tableName = "forest_server";
        columnNames = new String[]{"serverid", "url", "status"};
        colTypes = new int[]{0, 1, 0};
        if (!this.copyTable(this.master, con, tableName, columnNames, colTypes)) {
            return false;
        }
        tableName = "forest_servdb";
        columnNames = new String[]{"dbno", "dbname", "serverid"};
        colTypes = new int[]{0, 1, 0};
        if (!this.copyTable(this.master, con, tableName, columnNames, colTypes)) {
            return false;
        }
        tableName = "forest_tablepart";
        columnNames = new String[]{"dbname", "table_name", "part_count", "part_type", "hash_name", "status"};
        colTypes = new int[]{1, 1, 0, 0, 1, 0};
        if (!this.copyTable(this.master, con, tableName, columnNames, colTypes)) {
            return false;
        }
        tableName = "forest_tablepartdtl";
        columnNames = new String[]{"dbno", "dbname", "table_name", "part_no", "priority"};
        colTypes = new int[]{0, 1, 1, 0, 0};
        if (!this.copyTable(this.master, con, tableName, columnNames, colTypes)) {
            return false;
        }
        tableName = "forest_partatr";
        columnNames = new String[]{"dbname", "table_name", "column_name", "column_no", "column_type"};
        colTypes = new int[]{1, 1, 1, 0, 1};
        if (!this.copyTable(this.master, con, tableName, columnNames, colTypes)) {
            return false;
        }
        tableName = "forest_hash";
        columnNames = new String[]{"name", "description", "class"};
        colTypes = new int[]{1, 1, 1};
        if (!this.copyTable(this.master, con, tableName, columnNames, colTypes)) {
            return false;
        }
        tableName = "forest_gsc";
        columnNames = new String[]{"serverid", "dbname"};
        colTypes = new int[]{0, 1};
        if (!this.copyTable(this.master, con, tableName, columnNames, colTypes)) {
            return false;
        }
        tableName = "forest_config";
        columnNames = new String[]{"configid", "description", "cache_reflesh", "retry_count", "defect_timeout", "distributed_connection", "pertition_mode", "syncronize_mode", "update_date"};
        colTypes = new int[]{1, 1, 0, 0, 0, 0, 0, 0, 2};
        if (!this.copyTable(this.master, con, tableName, columnNames, colTypes)) {
            return false;
        }
        try {
            int rc = this.executeUpdateGSC("INSERT INTO forest_gsc(serverid,dbname) VALUES (" + target.getId() + "," + "'" + this.getGscName() + "')");
            rc = con.createStatement().executeUpdate("INSERT INTO forest_gsc(serverid,dbname) VALUES (" + target.getId() + ",'" + this.getGscName() + "')");
            con.commit();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            this.closeWithoutError(con);
            return false;
        }
        try {
            con.close();
            this.close();
            this.open(this.hostName, this.portNumber, this.gscName, this.user, this.pass);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            return false;
        }
        return true;
    }

    private boolean copyTable(Connection srccon, Connection dstcon, String tableName, String[] columnNames, int[] colTypes) {
        try {
            String selectSQL = this.buildSelectSQL(tableName, columnNames);
            String insertSQL = this.buildInsertSQL(tableName, columnNames);
            ResultSet rs = srccon.createStatement().executeQuery(selectSQL);
            PreparedStatement pstmt = dstcon.prepareStatement(insertSQL);
            while (rs.next()) {
                for (int i = 0; i < columnNames.length; ++i) {
                    if (colTypes[i] == 0) {
                        pstmt.setInt(i + 1, rs.getInt(i + 1));
                        continue;
                    }
                    if (colTypes[i] == 1) {
                        pstmt.setString(i + 1, rs.getString(i + 1));
                        continue;
                    }
                    if (colTypes[i] != 2) continue;
                    pstmt.setTimestamp(i + 1, rs.getTimestamp(i + 1));
                }
                pstmt.executeUpdate();
            }
            pstmt.close();
            rs.close();
            dstcon.commit();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return false;
        }
        return true;
    }

    private String buildSelectSQL(String tableName, String[] columnNames) {
        String selectSql = "SELECT ";
        for (int i = 0; i < columnNames.length; ++i) {
            if (i > 0) {
                selectSql = selectSql + ",";
            }
            selectSql = selectSql + columnNames[i];
        }
        selectSql = selectSql + " FROM " + tableName;
        return selectSql;
    }

    private String buildInsertSQL(String tableName, String[] columnNames) {
        int i;
        String insertSql = "INSERT INTO " + tableName + "(";
        for (i = 0; i < columnNames.length; ++i) {
            if (i > 0) {
                insertSql = insertSql + ",";
            }
            insertSql = insertSql + columnNames[i];
        }
        insertSql = insertSql + " ) VALUES ( ";
        for (i = 0; i < columnNames.length; ++i) {
            if (i > 0) {
                insertSql = insertSql + ",";
            }
            insertSql = insertSql + '?';
        }
        insertSql = insertSql + " )";
        return insertSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drop(Instance target) {
        Connection con = null;
        try {
            con = target.getDatabaseConnection(TemplateDatabase, this.getUser(), this.getPassword());
            int rc = this.executeUpdateGSC("DELETE FROM forest_gsc WHERE serverid=" + target.getId());
            int[] instanceIds = this.getInstanceIds();
            String h = null;
            String p = null;
            for (int i = 0; i < instanceIds.length; ++i) {
                if (instanceIds[i] == target.getId()) continue;
                h = this.getInstance(instanceIds[i]).getHostName();
                p = this.getInstance(instanceIds[i]).getPortNumber();
                break;
            }
            this.close();
            this.open(h, p, this.gscName, this.getUser(), this.getPassword());
            Thread.sleep(3000L);
            con.createStatement().executeUpdate("DROP DATABASE " + this.getGscName());
            con.commit();
            this.closeWithoutError(con);
        }
        catch (Exception e) {
            try {
                Logger.error(e.getMessage());
                Logger.trace(e);
                boolean bl = false;
                this.closeWithoutError(con);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeWithoutError(con);
                throw throwable;
            }
        }
        return true;
    }

    public boolean equals(Instance ins) {
        Connection con1 = null;
        Connection con2 = null;
        Statement stmt1 = null;
        Statement stmt2 = null;
        Object rs1 = null;
        Object rs2 = null;
        boolean rc = true;
        boolean ok = true;
        try {
            con1 = GSCdata.connectdb(this.hostName, this.portNumber, this.gscName, this.getUser(), this.getPassword());
            con2 = GSCdata.connectdb(ins.getHostName(), ins.getPortNumber(), this.gscName, this.getUser(), this.getPassword());
            stmt1 = con1.createStatement();
            stmt2 = con2.createStatement();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            this.closeWithoutError(con1);
            this.closeWithoutError(con2);
            return false;
        }
        String sql = null;
        int colnum = 0;
        sql = "SELECT configid,description,cache_reflesh,retry_count,defect_timeout,distributed_connection,pertition_mode,syncronize_mode FROM forest_config ORDER BY configid";
        colnum = 8;
        rc = this.compareTable(stmt1, stmt2, sql, colnum);
        if (!rc) {
            Logger.notice(ins + ", forest_config comparison failed.");
        } else {
            Logger.debug(ins + ", forest_config ok.");
        }
        if (!rc) {
            ok = false;
        }
        if (!(rc = this.compareTable(stmt1, stmt2, sql = "SELECT serverid,dbname FROM forest_gsc ORDER BY serverid,dbname", colnum = 2))) {
            Logger.notice(ins + ", forest_gsc comparison failed.");
        } else {
            Logger.debug(ins + ", forest_gsc ok.");
        }
        if (!rc) {
            ok = false;
        }
        if (!(rc = this.compareTable(stmt1, stmt2, sql = "SELECT name,description,class FROM forest_hash ORDER BY name", colnum = 3))) {
            Logger.notice(ins + ", forest_hash comparison failed.");
        } else {
            Logger.debug(ins + ", forest_hash ok.");
        }
        if (!rc) {
            ok = false;
        }
        if (!(rc = this.compareTable(stmt1, stmt2, sql = "SELECT serverid,url,status FROM forest_server ORDER BY serverid", colnum = 3))) {
            Logger.notice(ins + ", forest_server comparison failed.");
        } else {
            Logger.debug(ins + ", forest_server ok.");
        }
        if (!rc) {
            ok = false;
        }
        if (!(rc = this.compareTable(stmt1, stmt2, sql = "SELECT dbno,dbname,serverid FROM forest_servdb ORDER BY dbno,dbname", colnum = 3))) {
            Logger.notice(ins + ", forest_servdb comparison failed.");
        } else {
            Logger.debug(ins + ", forest_servdb ok.");
        }
        if (!rc) {
            ok = false;
        }
        if (!(rc = this.compareTable(stmt1, stmt2, sql = "SELECT dbname,table_name,part_count,part_type,hash_name,status FROM forest_tablepart ORDER BY dbname,table_name", colnum = 6))) {
            Logger.notice(ins + ", forest_tablepart comparison failed.");
        } else {
            Logger.debug(ins + ", forest_tablepart ok.");
        }
        if (!rc) {
            ok = false;
        }
        if (!(rc = this.compareTable(stmt1, stmt2, sql = "SELECT dbno,dbname,table_name,part_no,priority FROM forest_tablepartdtl ORDER BY dbno,dbname,table_name,part_no", colnum = 5))) {
            Logger.notice(ins + ", forest_tablepartdtl comparison failed.");
        } else {
            Logger.debug(ins + ", forest_tablepartdtl ok.");
        }
        if (!rc) {
            ok = false;
        }
        if (!(rc = this.compareTable(stmt1, stmt2, sql = "SELECT dbname,table_name,column_name,column_no,column_type FROM forest_partatr ORDER BY dbname,table_name,column_name", colnum = 5))) {
            Logger.notice(ins + ", forest_partatr comparison failed.");
        } else {
            Logger.debug(ins + ", forest_partatr ok.");
        }
        if (!rc) {
            ok = false;
        }
        try {
            con1.close();
            con2.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            return false;
        }
        return ok;
    }

    private boolean compareTable(Statement stmt1, Statement stmt2, String sql, int colnum) {
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        boolean rc = true;
        try {
            rs1 = stmt1.executeQuery(sql);
            rs2 = stmt2.executeQuery(sql);
            block2: while (rs1.next()) {
                if (!rs2.next()) {
                    rc = false;
                    break;
                }
                for (int i = 1; i <= colnum; ++i) {
                    String c1 = rs1.getString(i);
                    String c2 = rs2.getString(i);
                    Logger.debug(" [" + c1 + ":" + c2 + "]");
                    if (c1 == null && c2 == null) continue;
                    if (c1 == null || c2 == null) {
                        rc = false;
                        continue block2;
                    }
                    if (c1.equals(c2)) continue;
                    rc = false;
                    continue block2;
                }
            }
            if (rs2.next()) {
                rc = false;
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            rc = false;
        }
        return rc;
    }

    private void closeWithoutError(Connection con) {
        if (con == null) {
            return;
        }
        try {
            con.close();
        }
        catch (Exception e) {
            Logger.warning("Exception caught while closing connection, but going to be ignored.");
            Logger.error(e.getMessage());
            Logger.trace(e);
        }
    }

    private void rollbackWithoutError(Connection con) {
        try {
            con.rollback();
        }
        catch (Exception e) {
            Logger.warning("Exception caught while roll-back, but going to be ignored.");
            Logger.error(e.getMessage());
            Logger.trace(e);
        }
    }

    public BrokenLog[] getBrokenLogs() {
        ResultSet rs = null;
        ArrayList<BrokenLog> a = new ArrayList<BrokenLog>();
        String sql = "SELECT serverid,datetime,client,msg,status,query   FROM forest_brokenlog ORDER BY datetime";
        try {
            rs = this.executeQueryGSC(sql);
            while (rs.next()) {
                BrokenLog b = new BrokenLog(rs.getInt("serverid"), rs.getTimestamp("datetime"), rs.getString("client"), rs.getString("msg"), rs.getString("status"), rs.getString("query"));
                a.add(b);
            }
            rs.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            return null;
        }
        BrokenLog[] bb = new BrokenLog[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            bb[i] = (BrokenLog)a.get(i);
        }
        return bb;
    }

    public void clearBrokenLogs() {
        String sql = "DELETE FROM forest_brokenlog";
        try {
            int rc = this.executeUpdateGSC(sql);
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
        }
    }

    public int[] getGscInstances() {
        ArrayList<Integer> a = new ArrayList<Integer>();
        try {
            ResultSet rs = this.executeQueryGSC("SELECT serverid FROM forest_gsc WHERE dbname='" + this.gscName + "'");
            while (rs.next()) {
                a.add(new Integer(rs.getInt(1)));
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            return null;
        }
        return ArrayUtil.array2intarray(a);
    }

    public boolean validate(int flags) {
        boolean rc = true;
        try {
            String[] dbNames = this.getDatabaseNames();
            for (int i = 0; i < dbNames.length; ++i) {
                Database d = this.getDatabase(dbNames[i]);
                if (!d.validate(flags)) {
                    Logger.error("Database `" + d.getDatabaseName() + "' is under inconsistent.");
                    rc = false;
                    continue;
                }
                Logger.debug("Database `" + d.getDatabaseName() + "' is under consistent.");
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            Logger.trace(e);
            return false;
        }
        return rc;
    }
}

