/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli.action;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.Database;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GT;
import org.postgresforest.tool.lib.Table;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Misc;
import org.postgresforest.tool.util.Table2StringUtil;

public class TableActions {
    private static final String[] SHOW_TABLE_HEADER = new String[]{"TABLENAME", "TABLETYPE", "PARTITION_FUNC", "STATUS"};
    private static final String[] SHOW_COLUMN_HEADER = new String[]{"PARTITION_KEY", "COLUMNNAME", "DATATYPE"};
    private static final int REST_MODE = 1;
    private static final int NOREST_MODE = 0;
    private static final String DEFAULT_HASH = "default";
    private static final String HASH_OPTION_NAME = "hashname";
    protected static DecimalFormat m_dcFmt = new DecimalFormat("00");

    private static boolean _part(String tableName, int partCount, ArrayList partColumns, ArrayList paramNames, ArrayList paramValues, Database database) {
        if (tableName == null || tableName.equals("")) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return false;
        }
        Table table = database.getTable(tableName);
        if (table == null) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)tableName));
            return false;
        }
        String hashName = null;
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = (String)paramNames.get(i);
            if (paramName.equalsIgnoreCase(HASH_OPTION_NAME)) {
                hashName = (String)paramValues.get(i);
                if (!hashName.equals(DEFAULT_HASH)) continue;
                hashName = null;
                continue;
            }
            Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3055\u308c\u305f\u30d1\u30e9\u30e1\u30fc\u30bf \"{0}\" \u306f\u7121\u52b9\u3067\u3059\u3002", (String)paramName));
            return false;
        }
        int serverSize = database.getInstanceIds().length;
        if (partCount < 2 || partCount > serverSize) {
            Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3057\u305f\u30d1\u30fc\u30c6\u30a3\u30b7\u30e7\u30f3\u6570 \"{0}\" \u306f\u7121\u52b9\u3067\u3059\u3002", (String)Integer.toString(partCount)));
            return false;
        }
        String[] partColumnsName = partColumns.toArray(new String[0]);
        try {
            if (table.part(partColumnsName, partCount, hashName)) {
                Logger.notice((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u3092\u30d1\u30fc\u30c6\u30a3\u30b7\u30e7\u30f3\u5316\u3057\u307e\u3057\u305f\u3002", (String)tableName));
                return true;
            }
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u306e\u30d1\u30fc\u30c6\u30a3\u30b7\u30e7\u30f3\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)tableName));
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u306e\u30d1\u30fc\u30c6\u30a3\u30b7\u30e7\u30f3\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)tableName));
            Logger.detail((String)e.getDetail().getMessage());
            Logger.trace((Exception)e.getDetail());
        }
        return false;
    }

    public static void part(CommandParser cp, Database database) {
        TableActions._part(cp.getTables(), cp.getPartCnt(), cp.getKeyCol(), cp.getParamName(), cp.getParamValue(), database);
    }

    public static void part2(CommandParser cp, Database database) {
        if (!TableActions._part(cp.getTables(), cp.getPartCnt(), cp.getKeyCol(), cp.getParamName(), cp.getParamValue(), database)) {
            return;
        }
        ArrayList setServerList = cp.getServer();
        int[] serverIds = database.getInstanceIds();
        Iterator iter = setServerList.iterator();
        while (iter.hasNext()) {
            String severID = (String)iter.next();
            int setid = Integer.parseInt(severID);
            if (Misc.contains(setid, serverIds)) continue;
            Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3057\u305f\u30b5\u30fc\u30d0ID \"{0}\" \u306b\u306f\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{1}\" \u306f\u3042\u308a\u307e\u305b\u3093\u3002", (String)severID, (String)database.getDatabaseName()));
            return;
        }
        HashMap part2NoListMap = cp.getPart2NoListMap();
        Table table = database.getTable(cp.getTables());
        for (int i = 0; i < serverIds.length; ++i) {
            int k;
            int serverId = serverIds[i];
            ArrayList partNoList = (ArrayList)part2NoListMap.get(String.valueOf(serverId));
            if (partNoList == null) {
                for (k = 0; k < cp.getPartCnt(); ++k) {
                    if (table.dropPart(k, serverId)) continue;
                    Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0ID \"{0}\" \u306b\u304a\u3044\u3066\u3001\u30c6\u30fc\u30d6\u30eb \"{1}\" \u306e\u30d1\u30fc\u30c6\u30a3\u30b7\u30e7\u30f3 \"{2}\" \u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)Integer.toString(serverId), (String)cp.getTables(), (String)Integer.toString(k)));
                    return;
                }
                continue;
            }
            for (k = 0; k < cp.getPartCnt(); ++k) {
                if (partNoList.contains(String.valueOf(k)) || table.dropPart(k, serverId)) continue;
                Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0ID \"{0}\" \u306b\u304a\u3044\u3066\u3001\u30c6\u30fc\u30d6\u30eb \"{1}\" \u306e\u30d1\u30fc\u30c6\u30a3\u30b7\u30e7\u30f3 \"{2}\" \u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)Integer.toString(serverId), (String)cp.getTables(), (String)Integer.toString(k)));
                return;
            }
        }
        Logger.notice((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u3092\u30d1\u30fc\u30c6\u30a3\u30b7\u30e7\u30f3\u5316\u3057\u307e\u3057\u305f\u3002", (String)cp.getTables()));
    }

    public static void unpart(CommandParser cp, Database database) {
        String tableName = cp.getTables();
        if (tableName == null || tableName.equals("")) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        Table table = database.getTable(tableName);
        if (table == null) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)tableName));
            return;
        }
        try {
            if (table.unpart()) {
                Logger.notice((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u3092\u591a\u91cd\u5316\u30c6\u30fc\u30d6\u30eb\u306b\u5909\u66f4\u3057\u307e\u3057\u305f\u3002", (String)tableName));
            } else {
                Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u306e\u591a\u91cd\u5316\u30c6\u30fc\u30d6\u30eb\u3078\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)tableName));
            }
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u306e\u591a\u91cd\u5316\u30c6\u30fc\u30d6\u30eb\u3078\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)tableName));
            Logger.detail((String)e.getDetail().getMessage());
            Logger.trace((Exception)e.getDetail());
        }
    }

    public static void showTable(Database database) {
        String[] tables;
        try {
            tables = database.getTableNames();
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb\u540d\u4e00\u89a7\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002"));
            Logger.detail((String)e.getDetail().getMessage());
            Logger.trace((Exception)e.getDetail());
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.table.show"));
        Table2StringUtil table2StringUtil = new Table2StringUtil(SHOW_TABLE_HEADER);
        for (int i = 0; i < tables.length; ++i) {
            String tableName = tables[i];
            Table table = database.getTable(tableName);
            if (table == null) {
                Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)tableName));
                return;
            }
            ArrayList<String> row = new ArrayList<String>();
            row.add(tableName);
            int type = table.getTableType();
            row.add(TableActions.convertTableType(type));
            String hashname = table.getHashName();
            if (hashname != null) {
                row.add(hashname);
            } else if (type == 1 || type == 2) {
                row.add("DEFAULT");
            } else {
                row.add("");
            }
            row.add(TableActions.convertTableStatus(table.getStatus()));
            table2StringUtil.addRow(row);
        }
        table2StringUtil.print();
    }

    public static void showTableColumn(CommandParser cp, Database database) {
        String tableName = cp.getTables();
        if (tableName == null || tableName.equals("")) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        TableActions.showTableColumn(tableName, database);
    }

    public static void showTableColumn(String tableName, Database database) {
        Table table = database.getTable(tableName);
        if (table == null) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)tableName));
            return;
        }
        String[] columnNames = null;
        ArrayList<String> partitonKeyList = null;
        try {
            columnNames = table.getColumnNames();
            partitonKeyList = new ArrayList<String>(Arrays.asList(table.getPartitionKeys()));
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u306e\u30ab\u30e9\u30e0\u540d\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002", (String)tableName));
            Logger.detail((String)e.getDetail().getMessage());
            Logger.trace((Exception)e.getDetail());
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.tablecolumn.show", new Object[]{tableName}));
        Table2StringUtil table2StringUtil = new Table2StringUtil(SHOW_COLUMN_HEADER);
        String columnName = null;
        try {
            for (int i = 0; i < columnNames.length; ++i) {
                columnName = columnNames[i];
                ArrayList<String> row = new ArrayList<String>();
                row.add(TableActions.convertPartKey(columnName, partitonKeyList));
                row.add(columnName);
                row.add(table.getColumnType(columnName));
                table2StringUtil.addRow(row);
            }
            table2StringUtil.print();
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"\u30ab\u30e9\u30e0 \"{0}\" \u306e\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", columnName));
            Logger.detail((String)e.getDetail().getMessage());
            Logger.trace((Exception)e.getDetail());
        }
    }

    public static void setPriority(CommandParser cp, Database database) {
        String tableName = cp.getTables();
        if (tableName == null || tableName.equals("")) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        Table table = database.getTable(tableName);
        if (table == null) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)tableName));
            return;
        }
        int partNo = cp.getPartNo();
        ArrayList serverList = cp.getServer();
        for (int pri = 0; pri < serverList.size(); ++pri) {
            int serverid = Integer.parseInt((String)serverList.get(pri));
            if (!table.setPriority(serverid, partNo, pri)) {
                Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0ID \"{0}\" \u4e0a\u306e\u30c6\u30fc\u30d6\u30eb \"{1}\" \uff0f\u30d1\u30fc\u30c6\u30a3\u30b7\u30e7\u30f3 \"{2}\" \u306e\u512a\u5148\u5ea6\u3092\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", (String)Integer.toString(serverid), (String)tableName, (String)Integer.toString(partNo)));
                return;
            }
            Logger.debug((String)("setPriority: serverid=" + serverid + ",partition=" + partNo + ",priority=" + pri));
        }
        Logger.notice((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u306e\u30d1\u30fc\u30c6\u30a3\u30b7\u30e7\u30f3 \"{1}\" \u306e\u512a\u5148\u5ea6\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002", (String)tableName, (String)Integer.toString(partNo)));
    }

    public static void showPriority(CommandParser cp, Database database) {
        String tableName = cp.getTables();
        if (tableName == null || tableName.equals("")) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        TableActions.showPriority(tableName, database);
    }

    public static void showPriority(String tableName, Database database) {
        Table table = database.getTable(tableName);
        if (table == null) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)tableName));
            return;
        }
        int partCount = table.getPartCount();
        if (partCount == 1) {
            Logger.notice((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb \"{0}\" \u306f\u30d1\u30fc\u30c6\u30a3\u30b7\u30e7\u30f3\u30c6\u30fc\u30d6\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002", (String)tableName));
            return;
        }
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add(0, "SERVERID");
        for (int i = 0; i < table.getPartCount(); ++i) {
            columnList.add(tableName + "_" + m_dcFmt.format(i));
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.priority.show", new Object[]{tableName}));
        Table2StringUtil table2StringUtil = new Table2StringUtil(columnList);
        try {
            int[] ids = table.getInstanceIds();
            for (int j = 0; j < ids.length; ++j) {
                ArrayList<Object> row = new ArrayList<Object>();
                int serverId = ids[j];
                row.add(new Integer(serverId));
                for (int i = 1; i < columnList.size(); ++i) {
                    int priority = table.getPriority(serverId, i - 1);
                    if (priority < 0) {
                        row.add("");
                        continue;
                    }
                    row.add(new Integer(priority));
                }
                table2StringUtil.addRow(row);
            }
            table2StringUtil.print();
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"\u30d1\u30fc\u30c6\u30a3\u30b7\u30e7\u30f3\u30c6\u30fc\u30d6\u30eb\u306e\u30b5\u30fc\u30d0\u307e\u305f\u306f\u512a\u5148\u5ea6\u60c5\u5831\u306e\u53d6\u5f97\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002"));
            Logger.detail((String)e.getDetail().getMessage());
            Logger.trace((Exception)e.getDetail());
        }
    }

    private static String convertTableType(int type) {
        String ret = "";
        if (type == 0) {
            ret = GT.tr((String)"\u591a\u91cd\u5316");
        } else if (type == 1) {
            ret = GT.tr((String)"\u30d1\u30fc\u30c6\u30a3\u30b7\u30e7\u30f31");
        } else if (type == 2) {
            ret = GT.tr((String)"\u30d1\u30fc\u30c6\u30a3\u30b7\u30e7\u30f32");
        } else {
            ret = GT.tr((String)"\u4e0d\u660e");
            Logger.warning((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb\u30bf\u30a4\u30d7\u306b\u4e0d\u660e\u306a\u5024\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002"));
        }
        return ret;
    }

    private static String convertPartKey(String column, ArrayList partitionKeyList) {
        String ret = " ";
        ret = partitionKeyList.contains(column) ? " * " : "";
        return ret;
    }

    private static String convertTableStatus(int status) {
        String ret = "";
        if (status == 1) {
            ret = GT.tr((String)"\u30e1\u30f3\u30c6\u30ca\u30f3\u30b9\u4e2d");
        } else if (status == 0) {
            ret = GT.tr((String)"\u904b\u7528\u4e2d");
        } else {
            ret = GT.tr((String)"\u4e0d\u660e");
            Logger.warning((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb\u30b9\u30c6\u30fc\u30bf\u30b9\u306b\u4e0d\u660e\u306a\u5024\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002"));
        }
        return ret;
    }
}

