/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli.action;

import java.util.ArrayList;
import java.util.Iterator;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.Database;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.GT;
import org.postgresforest.tool.lib.Instance;
import org.postgresforest.tool.lib.Table;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Misc;
import org.postgresforest.tool.util.Parser;
import org.postgresforest.tool.util.Table2StringUtil;

public class DbActions {
    private static final String[] SHOW_DB_HEADER = new String[]{"DBNAME", "SERVERID", "HOST", "PORT"};

    public static void create(CommandParser cp, GSCdata gsc) {
        String dbName = cp.getDB();
        if (dbName == null || dbName.equals("")) {
            Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        String option = "";
        Iterator it = cp.getOption().iterator();
        while (it.hasNext()) {
            option = option + (String)it.next();
        }
        ArrayList chkServerList = cp.getServer();
        String serverListStr = "";
        int[] ids = new int[chkServerList.size()];
        for (int i = 0; i < ids.length; ++i) {
            String idStr = (String)chkServerList.get(i);
            ids[i] = Integer.parseInt(idStr);
            serverListStr = serverListStr + idStr + ",";
        }
        try {
            Database db;
            if (gsc.getDatabase(dbName) != null) {
                if (cp.isForce()) {
                    gsc.dropDatabase(dbName);
                } else {
                    Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u306f\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\u3002", (String)dbName));
                    return;
                }
            }
            if ((db = option.equals("") ? gsc.createDatabase(ids, dbName) : gsc.createDatabase(ids, dbName, option)) == null) {
                Logger.error((String)MessagesCommandLine.getString("cui.error.db.create", new Object[]{dbName, serverListStr}));
                return;
            }
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u3092\u30b5\u30fc\u30d0ID \"{1}\" \u4e0a\u306b\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", (String)dbName, (String)serverListStr));
            return;
        }
        Logger.notice((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u3092\u30b5\u30fc\u30d0ID \"{1}\" \u4e0a\u306b\u4f5c\u6210\u3057\u307e\u3057\u305f\u3002", (String)dbName, (String)serverListStr));
    }

    public static void drop(CommandParser cp, GSCdata gsc) {
        String dbName = cp.getDB();
        if (dbName == null || dbName.equals("")) {
            Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        try {
            if (gsc.getDatabase(dbName) == null) {
                Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)dbName));
                return;
            }
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u306e\u60c5\u5831\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002", (String)dbName));
            Logger.detail((String)e.getDetail().getMessage());
            Logger.trace((Exception)e.getDetail());
        }
        boolean force = cp.isForce();
        if (!gsc.dropDatabase(dbName, force)) {
            Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)dbName));
            return;
        }
        Logger.notice((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002", (String)dbName));
    }

    public static void restore(CommandParser cp, GSCdata gsc) {
        Logger.warning((String)GT.tr((String)"restore db\u30b3\u30de\u30f3\u30c9\u306f\u73fe\u30d0\u30fc\u30b8\u30e7\u30f3\u3067\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
    }

    public static void show(GSCdata gsc) {
        String[] dbNames;
        try {
            dbNames = gsc.getDatabaseNames();
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u4e00\u89a7\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002"));
            Logger.error((String)e.getDetail().getMessage());
            Logger.trace((Exception)e.getDetail());
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.db.show"));
        Table2StringUtil table2StringUtil = new Table2StringUtil(SHOW_DB_HEADER);
        for (int i = 0; i < dbNames.length; ++i) {
            Database d = null;
            try {
                d = gsc.getDatabase(dbNames[i]);
            }
            catch (Exception e) {
                Logger.error((String)e.getMessage());
                Logger.trace((Exception)e);
                return;
            }
            int[] ids = d.getInstanceIds();
            for (int j = 0; j < ids.length; ++j) {
                Instance instance = gsc.getInstance(ids[j]);
                if (instance == null) {
                    Logger.error((String)MessagesCommandLine.getString("cui.error.gsc.show"));
                    return;
                }
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(dbNames[i]);
                row.add(new Integer(instance.getId()));
                row.add(instance.getHostName());
                row.add(instance.getPortNumber());
                table2StringUtil.addRow(row);
            }
        }
        table2StringUtil.print();
    }

    public static void createDbInstance(CommandParser cp, GSCdata gsc) {
        String dbName = cp.getDB();
        if (dbName == null || dbName.equals("")) {
            Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        int instanceId = Integer.parseInt((String)cp.getServer().get(0));
        boolean force = cp.isForce();
        Database database = null;
        try {
            database = gsc.getDatabase(dbName);
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u306e\u60c5\u5831\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002", (String)dbName));
            Logger.detail((String)e.getDetail().getMessage());
            Logger.trace((Exception)e.getDetail());
            return;
        }
        if (database == null) {
            Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)dbName));
            return;
        }
        Instance instance = gsc.getInstance(instanceId);
        if (instance == null) {
            Logger.error((String)GT.tr((String)"\u30b5\u30fc\u30d0 \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)Integer.toString(instanceId)));
            return;
        }
        int[] instanceIds = database.getInstanceIds();
        for (int i = 0; i < instanceIds.length; ++i) {
            if (instanceIds[i] != instanceId || force) continue;
            Logger.error((String)GT.tr((String)"\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9 \"{0}\" \u306f\u3001\u3059\u3067\u306b\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{1}\" \u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002", (String)Integer.toString(instanceId), (String)dbName));
            return;
        }
        if (!database.addInstance(instance, force)) {
            Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u3078\u306e\u30b5\u30fc\u30d0 \"{1}\" \u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)dbName, (String)Integer.toString(instanceId)));
            return;
        }
        Logger.notice((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u3078\u30b5\u30fc\u30d0 \"{1}\" \u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002", (String)dbName, (String)Integer.toString(instanceId)));
    }

    public static void dropDbInstance(CommandParser cp, GSCdata gsc) {
        String dbName = cp.getDB();
        if (dbName == null || dbName.equals("")) {
            Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        int instanceId = Integer.parseInt((String)cp.getServer().get(0));
        boolean force = cp.isForce();
        try {
            if (gsc.getDatabase(dbName) == null) {
                Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)dbName));
                return;
            }
            if (gsc.getInstance(instanceId) == null) {
                Logger.error((String)GT.tr((String)"\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9 \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)Integer.toString(instanceId)));
                return;
            }
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u307e\u305f\u306f\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u60c5\u5831\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002"));
            Logger.detail((String)e.getDetail().getMessage());
            Logger.trace((Exception)e.getDetail());
            return;
        }
        if (!gsc.dropDatabase(dbName, instanceId, force)) {
            Logger.error((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u304b\u3089\u306e\u30b5\u30fc\u30d0 \"{1}\" \u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)dbName, (String)Integer.toString(instanceId)));
            return;
        }
        Logger.notice((String)GT.tr((String)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \"{0}\" \u304b\u3089\u30b5\u30fc\u30d0 \"{1}\" \u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002", (String)dbName, (String)Integer.toString(instanceId)));
    }

    public static void executeDdl(String command, Parser parser, Database database) {
        try {
            Logger.notice((String)GT.tr((String)"\u5b9f\u884c\u30b3\u30de\u30f3\u30c9: {0}", (String)command));
            boolean statusOk = false;
            String tableName = null;
            int type = parser.getType();
            Table table = null;
            String indexName = null;
            switch (type) {
                case 1: {
                    if (parser.getTables().size() == 0) {
                        Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
                        break;
                    }
                    tableName = (String)parser.getTables().get(0);
                    if (database.getTable(tableName) != null) {
                        Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3057\u305f\u30c6\u30fc\u30d6\u30eb \"{0}\" \u304c\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002", (String)tableName));
                        break;
                    }
                    table = database.createTable(command);
                    if (table == null) break;
                    statusOk = true;
                    break;
                }
                case 6: {
                    if (parser.getTables().size() == 0) {
                        Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
                        break;
                    }
                    tableName = (String)parser.getTables().get(0);
                    table = database.getTable(tableName);
                    if (table == null) {
                        Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3057\u305f\u30c6\u30fc\u30d6\u30eb \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)tableName));
                        break;
                    }
                    statusOk = table.alter(command);
                    break;
                }
                case 2: {
                    if (parser.getTables().size() == 0) {
                        Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
                        break;
                    }
                    tableName = (String)parser.getTables().get(0);
                    if (database.getTable(tableName) == null) {
                        Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3057\u305f\u30c6\u30fc\u30d6\u30eb \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)tableName));
                        break;
                    }
                    statusOk = database.dropTable(tableName);
                    break;
                }
                case 3: {
                    if (parser.getTables().size() == 0) {
                        Logger.error((String)GT.tr((String)"\u30d3\u30e5\u30fc\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
                        break;
                    }
                    tableName = (String)parser.getTables().get(0);
                    if (database.getTable(tableName) != null) {
                        Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3057\u305f\u30d3\u30e5\u30fc\u307e\u305f\u306f\u30c6\u30fc\u30d6\u30eb \"{0}\" \u304c\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002", (String)tableName));
                        break;
                    }
                    table = database.createView(command);
                    if (table == null) break;
                    statusOk = true;
                    break;
                }
                case 4: {
                    if (parser.getTables().size() == 0) {
                        Logger.error((String)GT.tr((String)"\u30d3\u30e5\u30fc\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
                        break;
                    }
                    tableName = (String)parser.getTables().get(0);
                    if (database.getTable(tableName) == null) {
                        Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3057\u305f\u30d3\u30e5\u30fc \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)tableName));
                        break;
                    }
                    statusOk = database.dropView(tableName);
                    break;
                }
                case 5: {
                    if (parser.getTables().size() == 0) {
                        Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
                        break;
                    }
                    tableName = (String)parser.getTables().get(0);
                    table = database.getTable(tableName);
                    if (table == null) {
                        Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3057\u305f\u30c6\u30fc\u30d6\u30eb \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)tableName));
                        break;
                    }
                    statusOk = table.createIndex(command);
                    break;
                }
                case 8: {
                    indexName = parser.getReplaceWord();
                    table = DbActions.indexGetTable(database, indexName);
                    if (table == null) {
                        Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3057\u305f\u30a4\u30f3\u30c7\u30c3\u30af\u30b9 \"{0}\" \u3092\u6301\u3064\u30c6\u30fc\u30d6\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)indexName));
                        break;
                    }
                    statusOk = table.alter(command);
                    break;
                }
                case 7: {
                    indexName = parser.getReplaceWord();
                    table = DbActions.indexGetTable(database, indexName);
                    if (table == null) {
                        Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3057\u305f\u30a4\u30f3\u30c7\u30c3\u30af\u30b9 \"{0}\" \u3092\u6301\u3064\u30c6\u30fc\u30d6\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)indexName));
                        break;
                    }
                    statusOk = table.dropIndex(indexName);
                    break;
                }
                default: {
                    Logger.error((String)GT.tr((String)"\u7279\u5b9a\u306eDDL\u30b3\u30de\u30f3\u30c9\u4ee5\u5916\u306e\u5b9f\u884c\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
                }
            }
            if (statusOk) {
                Logger.notice((String)GT.tr((String)"DDL\u30b3\u30de\u30f3\u30c9\u306e\u5b9f\u884c\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002"));
            } else {
                Logger.error((String)GT.tr((String)"DDL\u30b3\u30de\u30f3\u30c9\u306e\u5b9f\u884c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"));
            }
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"DDL\u30b3\u30de\u30f3\u30c9\u306e\u5b9f\u884c\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002"));
            Logger.detail((String)e.getDetail().getMessage());
            Logger.trace((Exception)e.getDetail());
        }
    }

    private static Table indexGetTable(Database database, String indexName) {
        String table = DbActions.indexGetRelationName(database, indexName);
        Table t = null;
        if (table != null) {
            t = database.getTable(table);
            if (t == null) {
                Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3057\u305f\u30c6\u30fc\u30d6\u30eb \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)table));
            }
        } else {
            Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3057\u305f\u30a4\u30f3\u30c7\u30c3\u30af\u30b9 \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)indexName));
        }
        return t;
    }

    private static String indexGetRelationName(Database database, String indexName) {
        String[] tables = null;
        try {
            tables = database.getTableNames();
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"\u30c6\u30fc\u30d6\u30eb\u540d\u4e00\u89a7\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002"));
            Logger.detail((String)e.getDetail().getMessage());
            Logger.trace((Exception)e.getDetail());
            return null;
        }
        if (tables.length == 0) {
            Logger.error((String)GT.tr((String)"\u524a\u9664\u3059\u308b\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return null;
        }
        for (int i = 0; i < tables.length; ++i) {
            Table t = database.getTable(tables[i]);
            String[] indexNames = t.getIndexNames();
            if (!Misc.containsIgnoreCase(indexName, indexNames)) continue;
            return tables[i];
        }
        return null;
    }
}

