/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli.action;

import java.util.ArrayList;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.Config;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.GT;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Table2StringUtil;

public class ConfigActions {
    private static final String[] SHOW_CONFIG_HEADER = new String[]{"CONFIG", "DESCRIPTION", "CACHE_REFRESH", "RETRY_COUNT", "DETECT_TIMEOUT", "DISTRIBUTED_CONNECTION ", "NON-PARTITION_MODE", "SYNCRONIZE_MODE"};
    private static final String CFGNAME_OPTION_NAME = "cfgname";
    private static final String DESCRIPTION_OPTION_NAME = "descript";
    private static final String REFRESH_OPTION_NAME = "refresh";
    private static final String RETRYCOUNT_OPTION_NAME = "retry";
    private static final String DETECTTIMEOUT_OPTION_NAME = "timeout";
    private static final String DISTRIBUTION_OPTION_NAME = "dist";
    private static final String PARTMODE_OPTION_NAME = "pmode";
    private static final String SYNCMODE_OPTION_NAME = "smode";

    public static void create(CommandParser cp, GSCdata gsc) {
        String cfgName = cp.getConfigName();
        if (cfgName == null || cfgName.equals("")) {
            Logger.error((String)GT.tr((String)"CONFIG\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        Config config = gsc.createConfig(cfgName);
        if (config == null) {
            Logger.error((String)GT.tr((String)"CONFIG \"{0}\" \u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", (String)cfgName));
            return;
        }
        Logger.notice((String)GT.tr((String)"CONFIG \"{0}\" \u3092\u4f5c\u6210\u3057\u307e\u3057\u305f\u3002", (String)cfgName));
    }

    public static void drop(CommandParser cp, GSCdata gsc) {
        String id = cp.getConfigName();
        if (id == null || id.equals("")) {
            Logger.error((String)GT.tr((String)"CONFIG\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        if (id.equals("FOREST_DEFAULT_CONFIG")) {
            Logger.error((String)GT.tr((String)"\u30c7\u30d5\u30a9\u30eb\u30c8\u306eCONFIG \"{0}\" \u306f\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002", (String)"FOREST_DEFAULT_CONFIG"));
            return;
        }
        if (gsc.getConfig(id) == null) {
            Logger.error((String)GT.tr((String)"CONFIG \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)id));
            return;
        }
        if (!gsc.dropConfig(id)) {
            Logger.error((String)GT.tr((String)"CONFIG \"{0}\" \u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", (String)id));
            return;
        }
        Logger.notice((String)GT.tr((String)"CONFIG \"{0}\" \u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002", (String)id));
    }

    public static void set(CommandParser cp, GSCdata gsc) {
        String id = cp.getConfigName();
        if (id == null || id.equals("")) {
            Logger.error((String)GT.tr((String)"CONFIG\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        Config config = gsc.getConfig(id);
        if (config == null) {
            Logger.error((String)GT.tr((String)"CONFIG \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)id));
            return;
        }
        ArrayList paramNames = cp.getParamName();
        ArrayList paramValues = cp.getParamValue();
        for (int i = 0; i < paramNames.size(); ++i) {
            boolean rc;
            String paramName;
            block14: {
                paramName = (String)paramNames.get(i);
                rc = false;
                try {
                    if (paramName.equalsIgnoreCase(CFGNAME_OPTION_NAME)) {
                        String cfgName = (String)paramValues.get(i);
                        rc = config.setId(cfgName);
                        break block14;
                    }
                    if (paramName.equalsIgnoreCase(DESCRIPTION_OPTION_NAME)) {
                        String descript = (String)paramValues.get(i);
                        rc = config.setDescription(descript);
                        break block14;
                    }
                    if (paramName.equalsIgnoreCase(REFRESH_OPTION_NAME)) {
                        int refresh = Integer.parseInt((String)paramValues.get(i));
                        rc = config.setCacheRefresh(refresh);
                        break block14;
                    }
                    if (paramName.equalsIgnoreCase(RETRYCOUNT_OPTION_NAME)) {
                        int retry = Integer.parseInt((String)paramValues.get(i));
                        rc = config.setRetryCount(retry);
                        break block14;
                    }
                    if (paramName.equalsIgnoreCase(DETECTTIMEOUT_OPTION_NAME)) {
                        int timeout = Integer.parseInt((String)paramValues.get(i));
                        rc = config.setDefectTimeout(timeout);
                        break block14;
                    }
                    if (paramName.equalsIgnoreCase(DISTRIBUTION_OPTION_NAME)) {
                        int dist = Integer.parseInt((String)paramValues.get(i));
                        rc = config.setDistributedConnection(dist);
                        break block14;
                    }
                    if (paramName.equalsIgnoreCase(PARTMODE_OPTION_NAME)) {
                        String pmode = (String)paramValues.get(i);
                        rc = config.setPartitionMode(Integer.parseInt(pmode));
                        break block14;
                    }
                    if (paramName.equalsIgnoreCase(SYNCMODE_OPTION_NAME)) {
                        String smode = (String)paramValues.get(i);
                        rc = config.setSynchronizeMode(Integer.parseInt(smode));
                        break block14;
                    }
                    Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3057\u305fCONFIG\u30d1\u30e9\u30e1\u30fc\u30bf \"{0}\" \u306f\u7121\u52b9\u3067\u3059\u3002", (String)paramName));
                    return;
                }
                catch (NumberFormatException e) {
                    Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3057\u305fCONFIG\u30d1\u30e9\u30e1\u30fc\u30bf \"{0}\" \u306e\u8a2d\u5b9a\u5024 \"{1}\" \u306f\u7121\u52b9\u3067\u3059\u3002", (String)paramName, (String)((String)paramValues.get(i))));
                    Logger.detail((String)e.getMessage());
                    Logger.trace((Exception)e);
                    return;
                }
            }
            if (!rc) {
                Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3057\u305fCONFIG\u30d1\u30e9\u30e1\u30fc\u30bf \"{0}\" \u306e\u8a2d\u5b9a\u5024 \"{1}\" \u306f\u7121\u52b9\u3067\u3059\u3002", (String)paramName, (String)((String)paramValues.get(i))));
                return;
            }
            Logger.notice((String)GT.tr((String)"CONFIG \"{0}\" \u306e\u30d1\u30e9\u30e1\u30fc\u30bf \"{1}\" \u3092 \"{2}\" \u306b\u5909\u66f4\u3057\u307e\u3057\u305f\u3002", (String)id, (String)paramName, (String)((String)paramValues.get(i))));
        }
    }

    public static void replicate(CommandParser cp, GSCdata gsc) {
        String srcCfgName = cp.getConfigName();
        if (srcCfgName == null || srcCfgName.equals("")) {
            Logger.error((String)GT.tr((String)"\u8907\u88fd\u5143\u306eCONFIG\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        String destCfgName = cp.getConfigCopyName();
        if (destCfgName == null || destCfgName.equals("")) {
            Logger.error((String)GT.tr((String)"\u8907\u88fd\u5148\u306eCONFIG\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"));
            return;
        }
        if (gsc.getConfig(srcCfgName) == null) {
            Logger.error((String)GT.tr((String)"\u8907\u88fd\u5143\u306eCONFIG \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)srcCfgName));
            return;
        }
        if (gsc.getConfig(destCfgName) != null) {
            Logger.error((String)GT.tr((String)"\u8907\u88fd\u5148\u306eCONFIG \"{0}\" \u304c\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\u3002", (String)destCfgName));
            return;
        }
        Config config = gsc.createConfig(destCfgName, srcCfgName);
        if (config == null) {
            Logger.error((String)GT.tr((String)"CONFIG\u306e \"{0}\" \u304b\u3089 \"{1}\" \u3078\u306e\u8907\u88fd\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (String)srcCfgName, (String)destCfgName));
            return;
        }
        Logger.notice((String)GT.tr((String)"CONFIG\u3092 \"{0}\" \u304b\u3089 \"{1}\" \u3078\u8907\u88fd\u3057\u307e\u3057\u305f\u3002", (String)srcCfgName, (String)destCfgName));
    }

    public static void show(GSCdata gsc) {
        String[] configNames;
        try {
            configNames = gsc.getConfigNames();
        }
        catch (ForestToolException e) {
            Logger.error((String)GT.tr((String)"CONFIG\u540d\u4e00\u89a7\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002"));
            Logger.detail((String)e.getDetail().getMessage());
            Logger.trace((Exception)e.getDetail());
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.config.show"));
        Table2StringUtil table2StringUtil = new Table2StringUtil(SHOW_CONFIG_HEADER);
        for (int i = 0; i < configNames.length; ++i) {
            Config config = gsc.getConfig(configNames[i]);
            if (config == null) {
                Logger.error((String)GT.tr((String)"CONFIG \"{0}\" \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", (String)configNames[i]));
                return;
            }
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(config.getId());
            row.add(config.getDescription());
            row.add(new Integer(config.getCacheRefresh()));
            row.add(new Integer(config.getRetryCount()));
            row.add(new Integer(config.getDefectTimeout()));
            int distMode = config.getDistributedConnection();
            if (distMode == 0) {
                row.add(MessagesCommandLine.getString("form.config.distribution.roundrobin"));
            } else if (distMode == 1) {
                row.add(MessagesCommandLine.getString("form.config.distribution.fix"));
            } else {
                row.add("UNKNOWN VALUE");
            }
            int nonPartMode = config.getPartitionMode();
            if (nonPartMode == 1) {
                row.add(MessagesCommandLine.getString("yes"));
            } else if (nonPartMode == 0) {
                row.add(MessagesCommandLine.getString("no"));
            } else {
                row.add("UNKNOWN VALUE");
            }
            int syncMode = config.getSynchronizeMode();
            if (syncMode == 1) {
                row.add("Sync");
            } else if (syncMode == 0) {
                row.add("UnSync");
            } else {
                row.add("UNKNOWN VALUE");
            }
            table2StringUtil.addRow(row);
        }
        table2StringUtil.print();
    }
}

