/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli;

import java.io.IOException;
import java.sql.SQLException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.cli.ForestCommandLine;
import org.postgresforest.tool.cli.action.GscActions;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GT;
import org.postgresforest.tool.util.InputShadowPassword;

public class ForestTool {
    private static String gscHost = null;
    private static String gscPort = null;
    private static String gscName = null;
    private static String userName = null;
    private static String userPass = null;
    private static String dumpFile = null;
    private static String restFile = null;
    private static boolean makeGsc = false;
    private static String inputFile = null;
    private static boolean isInputFile = false;

    private static Option makeOption(boolean isRequired, boolean hasArg, String argName, String description, String longOpt, String opt) {
        OptionBuilder.isRequired((boolean)isRequired);
        OptionBuilder.hasArg((boolean)hasArg);
        OptionBuilder.withArgName((String)argName);
        OptionBuilder.withDescription((String)description);
        OptionBuilder.withLongOpt((String)longOpt);
        Option retOption = OptionBuilder.create((String)opt);
        return retOption;
    }

    private static void parseOptions(String[] args) throws ParseException {
        Options options = new Options();
        Option hostOption = ForestTool.makeOption(true, true, "host", "host name", "host", "h");
        Option portOption = ForestTool.makeOption(true, true, "port", "port no", "port", "p");
        Option gscOption = ForestTool.makeOption(true, true, "gsc", "GSC name", "gsc", "g");
        Option createGscOption = ForestTool.makeOption(false, false, "new gsc", "create initial GSC", "init", "i");
        Option userOption = ForestTool.makeOption(true, true, "user", "user name", "user", "U");
        Option passOption = ForestTool.makeOption(false, true, "pass", "user password", "password", "W");
        Option dumpOption = ForestTool.makeOption(false, true, "dump", "dump GSC", "dump", "D");
        Option restoreOption = ForestTool.makeOption(false, true, "rest", "restore GSC", "restore", "R");
        Option fileOption = ForestTool.makeOption(false, true, "file", "load command file", "file", "f");
        Option helpOption = ForestTool.makeOption(false, false, "", "help", "help", "?");
        Option logOption = ForestTool.makeOption(false, true, "log", "log level", "log", "l");
        options.addOption(hostOption);
        options.addOption(portOption);
        options.addOption(gscOption);
        options.addOption(createGscOption);
        options.addOption(userOption);
        options.addOption(passOption);
        OptionGroup og = new OptionGroup();
        og.addOption(dumpOption);
        og.addOption(restoreOption);
        og.addOption(fileOption);
        options.addOptionGroup(og);
        options.addOption(helpOption);
        options.addOption(logOption);
        GnuParser parser = new GnuParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
            if (cmd.hasOption("?")) {
                HelpFormatter help = new HelpFormatter();
                help.printHelp("ForestConfig", options, true);
                System.exit(1);
            }
        }
        catch (ParseException e) {
            HelpFormatter help = new HelpFormatter();
            help.printHelp("ForestConfig", options, true);
            System.exit(1);
        }
        if (cmd.hasOption("h")) {
            gscHost = cmd.getOptionValue("h");
        }
        if (cmd.hasOption("p")) {
            gscPort = cmd.getOptionValue("p");
        }
        if (cmd.hasOption("g")) {
            gscName = cmd.getOptionValue("g");
        }
        if (cmd.hasOption("i")) {
            makeGsc = true;
        }
        if (cmd.hasOption("U")) {
            userName = cmd.getOptionValue("U");
        }
        if (cmd.hasOption("W")) {
            userPass = cmd.getOptionValue("W");
        }
        if (cmd.hasOption("D")) {
            dumpFile = cmd.getOptionValue("D");
        }
        if (cmd.hasOption("R")) {
            restFile = cmd.getOptionValue("R");
        }
        if (cmd.hasOption("f")) {
            inputFile = cmd.getOptionValue("f");
            isInputFile = true;
        }
        if (cmd.hasOption("l")) {
            String loglevel = cmd.getOptionValue("l");
            int logLevelInt = 4;
            if (loglevel.equalsIgnoreCase("TRACE")) {
                logLevelInt = 10;
            } else if (loglevel.equalsIgnoreCase("DEBUG")) {
                logLevelInt = 5;
            } else if (loglevel.equalsIgnoreCase("LOG")) {
                logLevelInt = 4;
            } else if (loglevel.equalsIgnoreCase("NOTICE")) {
                logLevelInt = 3;
            } else if (loglevel.equalsIgnoreCase("WARNIG")) {
                logLevelInt = 2;
            } else if (loglevel.equalsIgnoreCase("ERROR")) {
                logLevelInt = 1;
            }
            Logger.setLevel((int)logLevelInt);
        }
    }

    public static void main(String[] args) {
        Logger.println((String)"Welcome to PostgresForest Command Line Tool. ");
        try {
            ForestTool.parseOptions(args);
        }
        catch (ParseException e) {
            Logger.error((String)GT.tr((String)"\u30aa\u30d7\u30b7\u30e7\u30f3\u306e\u6307\u5b9a\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002"));
            Logger.detail((String)e.getMessage());
            Logger.trace((Exception)((Object)e));
            System.exit(1);
        }
        Logger.println((String)("Connecting to Database GSC = " + gscHost + ":" + gscPort + "/" + gscName));
        Logger.println((String)"");
        if (userPass == null) {
            PasswordCallback pass = new PasswordCallback("Password >", false);
            Callback[] callbacks = new Callback[]{pass};
            InputShadowPassword cbHandler = new InputShadowPassword();
            try {
                cbHandler.handle(callbacks);
                userPass = new String(pass.getPassword());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsupportedCallbackException e) {
                e.printStackTrace();
            }
        }
        if (dumpFile != null) {
            Logger.println((String)"dump GSC");
            Logger.warning((String)"Not implemented yet");
        } else if (restFile != null) {
            Logger.println((String)"restore GSC");
            Logger.warning((String)"Not implemented yet");
        } else if (makeGsc) {
            GscActions.make(gscHost, gscPort, gscName, userName, userPass);
        } else {
            ForestCommandLine fc;
            try {
                fc = new ForestCommandLine(gscHost, gscPort, userName, userPass, gscName);
            }
            catch (ForestToolException e) {
                Logger.error((String)GT.tr((String)"\u6307\u5b9a\u3055\u308c\u305fGSC\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002"));
                Logger.detail((String)e.getDetail().getMessage());
                Logger.trace((Exception)e.getDetail());
                return;
            }
            if (isInputFile) {
                Logger.notice((String)GT.tr((String)"\u8aad\u307f\u8fbc\u307f\u30d5\u30a1\u30a4\u30eb: {0}", (String)inputFile));
                try {
                    fc.processCommandFile(inputFile);
                }
                catch (SQLException e) {
                    Logger.error((String)GT.tr((String)"\u30d5\u30a1\u30a4\u30eb\u51e6\u7406\u4e2d\u306bSQL\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: {0}", (String)inputFile));
                    Logger.detail((String)e.getMessage());
                    Logger.trace((Exception)e);
                }
                catch (IOException e) {
                    Logger.error((String)GT.tr((String)"\u30d5\u30a1\u30a4\u30eb\u51e6\u7406\u4e2d\u306bI/O\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: {0}", (String)inputFile));
                    Logger.detail((String)e.getMessage());
                    Logger.trace((Exception)e);
                }
            } else {
                try {
                    fc.commandLine();
                }
                catch (Exception e) {
                    Logger.error((String)"\u30b3\u30de\u30f3\u30c9\u5b9f\u884c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    Logger.detail((String)e.getMessage());
                    Logger.trace((Exception)e);
                }
            }
        }
    }
}

