/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.sql.SQLException;
import org.postgresforest.tool.ForestToolCommandLine;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.cli.AbstractCommandProcessor;
import org.postgresforest.tool.cli.GscDbCommandProcessor;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.GT;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

public class ForestCommandLine {
    private static ForestToolCommandLine ftc = null;
    private GSCdata m_gsc = null;
    boolean done = false;
    private String ExecLine = "";
    private AbstractCommandProcessor m_processor;

    public ForestCommandLine(String hostname, String portno, String username, String userpass, String gscname) throws ForestToolException {
        this.m_gsc = new GSCdata(hostname, portno, gscname, username, userpass);
        this.m_processor = new GscDbCommandProcessor(this.m_gsc);
        ftc = new ForestToolCommandLine();
    }

    public void commandLine() throws ClassNotFoundException, IOException, SQLException {
        StreamTokenizer input = new StreamTokenizer(new InputStreamReader(System.in));
        input.resetSyntax();
        input.slashSlashComments(true);
        input.eolIsSignificant(false);
        input.wordChars(32, 126);
        int tt = 0;
        int lineno = 1;
        boolean IsPronpt = true;
        while (tt != -1 && !this.done) {
            if (IsPronpt) {
                this.m_processor.printPrompt();
                IsPronpt = false;
            }
            try {
                tt = input.nextToken();
                if (tt != -3 && tt != 10) continue;
                if (input.ttype == 10) {
                    IsPronpt = true;
                    continue;
                }
                this.processLine(input.sval);
                ++lineno;
            }
            catch (SQLException e) {
                Logger.error((String)GT.tr((String)"\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002"));
                Logger.detail((String)e.getMessage());
                Logger.trace((Exception)e);
                this.ExecLine = "";
            }
        }
        try {
            this.m_gsc.close();
        }
        catch (Exception e) {
            Logger.error((String)GT.tr((String)"\u5207\u65ad\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002"));
            Logger.detail((String)e.getMessage());
            Logger.trace((Exception)e);
        }
        Logger.println((String)"Now closing the connection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLine(String line) throws SQLException {
        if (line.startsWith("--") || line.startsWith("#")) {
            return;
        }
        if (line.startsWith("\\")) {
            this.ExecLine = line.endsWith(";") ? line.substring(0, line.indexOf(59)) : line;
            this.processSlashCommand(this.ExecLine);
            this.ExecLine = "";
            return;
        }
        if (line.indexOf(59) < 0) {
            this.ExecLine = this.ExecLine + " " + line;
        } else {
            this.ExecLine = this.ExecLine + line.substring(0, line.indexOf(59));
            try {
                this.m_processor = this.m_processor.executeCommand(this.ExecLine);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.ExecLine = "";
            }
        }
    }

    public void processCommandFile(String filename) throws SQLException, IOException, FileNotFoundException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(filename));
        while ((line = br.readLine()) != null) {
            this.processLine(line);
        }
    }

    public void processSlashCommand(String line) throws SQLException {
        if (line.startsWith("\\i")) {
            if (line.startsWith("\\i ")) {
                String file = CommandParser.extractSlashCmdArgument(line, 3);
                try {
                    Logger.println((String)"execute command");
                    Logger.println((String)("  file\uff1a" + file));
                    this.ExecLine = "";
                    this.processCommandFile(file);
                }
                catch (IOException e) {
                    Logger.error((String)MessagesCommandLine.getString("cui.error.command.io", new Object[]{file}));
                    Logger.error((String)e.getMessage());
                    Logger.trace((Exception)e);
                }
            } else {
                Logger.println((String)MessagesCommandLine.getString("cui.help.back.i"));
            }
        } else if (line.startsWith("\\f")) {
            this.m_processor.processSlashCommand(line);
        } else if (line.startsWith("\\h")) {
            this.m_processor = this.m_processor.processSlashCommandHistory(line);
        } else if (line.equals("\\q")) {
            this.done = true;
        } else {
            Logger.error((String)MessagesCommandLine.getString("cui.error.back.f"));
            Logger.println((String)MessagesCommandLine.getString("cui.help.back.f"));
        }
    }
}

