/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli;

import java.sql.SQLException;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.cli.action.BrokenLogActions;
import org.postgresforest.tool.cli.action.ConfigActions;
import org.postgresforest.tool.cli.action.DbActions;
import org.postgresforest.tool.cli.action.GscActions;
import org.postgresforest.tool.cli.action.HashActions;
import org.postgresforest.tool.cli.action.HelpActions;
import org.postgresforest.tool.cli.action.InstanceActions;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.util.CommandHistory;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.ReWriter;

public abstract class AbstractCommandProcessor {
    protected GSCdata m_gsc = null;
    protected CommandHistory m_commandHistory;

    public AbstractCommandProcessor(GSCdata gsc) {
        this.m_gsc = gsc;
        this.m_commandHistory = new CommandHistory(30);
    }

    protected abstract void printPrompt();

    protected abstract AbstractCommandProcessor executeCommand(CommandParser var1, String var2);

    protected abstract void processSlashCommandTable(String var1);

    protected abstract void processSlashCommandPriority(String var1);

    public AbstractCommandProcessor executeCommand(String command) {
        this.m_commandHistory.add(command);
        return this._executeCommand(command);
    }

    protected AbstractCommandProcessor _executeCommand(String command) {
        CommandParser cp = null;
        try {
            command = ReWriter.toLowerSql(command);
            cp = new CommandParser(command);
        }
        catch (Exception e1) {
            return this;
        }
        int cpType = cp.getType();
        if (cp.isHelpCommand()) {
            HelpActions.show(cp);
        } else if (cpType == 99) {
            Logger.println((String)MessagesCommandLine.getString("cui.help.command.show"));
        } else if (cp.isHelpCommand()) {
            Logger.println((String)MessagesCommandLine.getString("cui.help.help.show"));
        } else {
            return this.executeCommand(cp, command);
        }
        return this;
    }

    public void processSlashCommand(String line) throws SQLException {
        if (line.startsWith("\\fi")) {
            InstanceActions.show(this.m_gsc);
        } else if (line.startsWith("\\fg")) {
            GscActions.show(this.m_gsc);
        } else if (line.startsWith("\\fd")) {
            DbActions.show(this.m_gsc);
        } else if (line.startsWith("\\fc")) {
            ConfigActions.show(this.m_gsc);
        } else if (line.startsWith("\\fh")) {
            HashActions.show(this.m_gsc);
        } else if (line.startsWith("\\fb")) {
            BrokenLogActions.show(this.m_gsc);
        } else if (line.startsWith("\\ft")) {
            this.processSlashCommandTable(line);
        } else if (line.startsWith("\\fp")) {
            this.processSlashCommandPriority(line);
        } else {
            Logger.error((String)MessagesCommandLine.getString("cui.error.back.f"));
            Logger.println((String)MessagesCommandLine.getString("cui.help.back.f"));
        }
    }

    public AbstractCommandProcessor processSlashCommandHistory(String line) {
        String index;
        if (line.startsWith("\\h ") && !(index = CommandParser.extractSlashCmdArgument(line, 3)).equals("")) {
            int indexNum;
            try {
                indexNum = Integer.parseInt(index);
            }
            catch (NumberFormatException e) {
                Logger.error((String)"Invalid argument(s).");
                Logger.error((String)e.getMessage());
                Logger.trace((Exception)e);
                return this;
            }
            String command = this.m_commandHistory.get(indexNum);
            return this._executeCommand(command);
        }
        this.m_commandHistory.printHistory();
        return this;
    }
}

