package org.postgresforest.vm.gsc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import org.postgresforest.vm.Hash_I;

/**
 * テーブル分割情報クラス
 *
 */
public class TableInfo {

	//Ver3.1オンラインメンテナンス
	public static final int TABLE_AVAILABLE   = 0;
	public static final int TABLE_UNAVAILABLE = 1;

	protected String m_name; //テーブル名
	//Ver2.0
	protected HashMap m_servers = new HashMap(); //サーバマップ(KEY:パーティションNo,VALUE:priority順のサーバリスト)
	protected ArrayList m_columnList; //パーティション属性情報リスト
	protected int m_partitionNum; //パーティション数 
	protected int m_type; //パーティション型 

	//Ver3.0	
	protected Hash_I m_Hash = null;	//パーティション分割用ハッシュ関数

	//Ver3.1	
	protected int m_status;	//テーブルのステータス（）


	/**
	 * @return
	 */
	public ArrayList getColumnList() {
		return m_columnList;
	}

	/**
	 * @return
	 */
	public String getName() {
		return m_name;
	}

	/**
	 * @return
	 */
	public ArrayList getServers() {

		//Ver2.0 -->
		//@@事前にサーバーのリストを作るべき？
		//return m_servers;

		//戻り値用のサーバリスト
		ArrayList servers = new ArrayList();  
		
		//サーバマップからリスト（priority順）を取り出す			
		for (Iterator iter = m_servers.values().iterator(); iter.hasNext();) {
			ArrayList svrList = (ArrayList) iter.next();
			
			//リストから戻り値のリスト用に格納する
			for (int i = 0; i < svrList.size(); i++) {
				ServerInfo srvinfo = (ServerInfo) svrList.get(i);
				
				//すでに戻り値にセットされているサーバを除いて戻り値に格納
				if ( servers.contains(srvinfo) == false ) {
					servers.add(srvinfo);
				}
			}
				
		}
		
		return servers;
		//Ver2.0 <--

	}


	/**
	 * @return
	 * @since 2.0
	 */
	public ArrayList getServers(int partNo) {
		return (ArrayList)m_servers.get(new Integer(partNo));
	}

	/**
	 * @param list
	 */
	public void setColumnList(ArrayList list) {
		m_columnList = list;
	}

	/**
	 * @param string
	 */
	public void setName(String string) {
		m_name = string;
	}

	/**
	 * @param list
	 * @since 2.0
	 */
	public void setServers(int partNo, ArrayList list) {
		m_servers.put(new Integer(partNo), list);
	}

	/**
	 * @param list
	 * @since 2.0
	 */
	public void setServers(int partNo, ServerInfo serverInfo) {
		ArrayList serverList = (ArrayList)getServers(partNo);
		if(serverList == null){
			//マップを作成する
			serverList = new ArrayList();
			serverList.add(serverInfo);
			setServers(partNo,serverList);
		}else{
			//リストにサーバ情報追加
			serverList.add(serverInfo);
		}
	}
	/**
	 * @return
	 */
	public boolean isPartition() {
		//return m_isPartition;
		if(m_partitionNum > 1){
			return true;
		}else{
			return false;
		}
	}

	/**
	 * @return
	 */
	public int getPartitionNum() {
		return m_partitionNum;
	}

	/**
	 * @return
	 */
	public int getType() {
		return m_type;
	}

	/**
	 * @param i
	 */
	public void setPartitionNum(int i) {
		m_partitionNum = i;
	}

	/**
	 * @param i
	 */
	public void setType(int i) {
		m_type = i;
	}

	/**
	 * @return
	 * @since 3.0
	 */
	public Hash_I getHash() {
		return m_Hash;
	}

	/**
	 * @param hash_I
	 * @since 3.0
	 */
	public void setHash(Hash_I hash_I) {
		m_Hash = hash_I;
	}
	
	/**
	 * @return
	 * @since 3.0
	 */
	public boolean isPartition2() {
		if(m_type == 2){
			return true;
		}else{
			return false;
		}
	}
	/**
	 * テーブルのステータス情報を取得する
	 *
	 * @return int テーブルステータス情報
	 *
	 * @since 3.1
	 */
	public int getStatus()
	{
		return m_status;
	}

	/**
	 * テーブルのステータス情報を設定する
	 *
	 * @param int status テーブルステータス情報
	 *
	 * @since 3.1
	 */
	public void setStatus(int status)
	{
		this.m_status = status;
	}		
}