package org.postgresforest.vm.gsc;

import java.sql.Connection;

import org.postgresforest.vm.Logger;

/**
 * サーバ情報クラス
 *
 */
public class ServerInfo {

	public static final int SERVER_RUNNING = 1;
	public static final int SERVER_TROUBLE = -1;

	
	protected int m_id; //サーバID
	protected int m_dbNo; //DBNO
	protected String m_url; //URL（DB除く）
	protected int m_status; //状態
	protected Connection m_con; //コネクション

	/**
	 * @return
	 */
	public int getId() {
		return m_id;
	}

	/**
	 * @return
	 */
	public int getStatus() {
		return m_status;
	}

	/**
	 * @return
	 */
	public String getUrl() {
		return m_url;
	}

	/**
	 * @param i
	 */
	public void setId(int i) {
		m_id = i;
	}

	/**
	 * @param i
	 */
	public void setStatus(int i) {
		m_status = i;
		Logger.debug("ServerInfo#setStatus() = " + i);
	}

	/**
	 * @param string
	 */
	public void setUrl(String string) {
		m_url = string;
	}

	/**
	 * @return 
	 */
	public Connection getConnection() {
		return m_con;
	}

	/**
	 * @param connection
	 */
	public void setConnection(Connection connection) {
		m_con = connection;
	}

	/**
	 * @return
	 */
	public int getDbNo() {
		return m_dbNo;
	}

	/**
	 * @param i
	 */
	public void setDbNo(int i) {
		m_dbNo = i;
	}

}
