package org.postgresforest.vm.gsc;

import java.sql.Date;

public class ConfigInfo {

	
	public static final int DIST_CON_ROUND_ROBIN = 0;
	public static final int DIST_CON_FIX = 1;

	protected String m_configID = null; //コンフィグ情報ID//Ver3.0
	protected int m_reflesh = 0; //キャッシュインターバル(秒)
	protected int m_retry = 0; //リトライカウントVer1.1
	protected int m_timeout = 300; //障害判定タイムアウト(秒)
	protected int m_distCon = DIST_CON_ROUND_ROBIN; //分散処理接続先
	protected boolean m_partitionMode = false; //非パーティション化モード許可//Ver3.0
	protected boolean m_updateSyncMode = false; //更新同期モード//Ver3.0
	protected Date m_configDate = null; //コンフィグ情報更新日時//Ver3.0

	
	public ConfigInfo(String configid) {
		super();
		m_configID = configid;
	}

	public Date getConfigDate() {
		return m_configDate;
	}
	public void setConfigDate(Date configDate) {
		m_configDate = configDate;
	}
	public String getConfigID() {
		return m_configID;
	}
	public int getDistCon() {
		return m_distCon;
	}
	public void setDistCon(int distCon) {
		m_distCon = distCon;
	}
	public boolean canPartitionMode() {
		return m_partitionMode;
	}
	public void setPartitionMode(boolean partitionMode) {
		m_partitionMode = partitionMode;
	}
	public int getReflesh() {
		return m_reflesh;
	}
	public void setReflesh(int reflesh) {
		m_reflesh = reflesh;
	}
	public int getRetry() {
		return m_retry;
	}
	public void setRetry(int retry) {
		m_retry = retry;
	}
	public int getTimeout() {
		return m_timeout;
	}
	public void setTimeout(int timeout) {
		m_timeout = timeout;
	}
	public boolean isUpdateSyncMode() {
		return m_updateSyncMode;
	}
	public void setUpdateSyncMode(boolean updateSyncMode) {
		m_updateSyncMode = updateSyncMode;
	}


}
