/*
 *  BrokenNotify_I.java
 *
 *  Copyright (C) 2005 NTT DATA Corporation. Open Source Development Center
 *  作成日: 2005/12/05
 */
package org.postgresforest.vm.err;

/**
 *
 * BrokenNotify_I
 * サーバステータス（切り離し）通知機能のインターフェース
 * @version $Revision: 1.1.2.1 $
 * @since 3.1 
 */
public interface BrokenNotify_I {
    /**
     * サーバ切り離し通知
     * @param url	サーバURL
     * @param msg	エラーメッセージ
     * @param status	エラーステータス
     * @param query		実行クエリー
     */
	public void notifyServerBroken(String url, String msg, String status, String query);
    /**
     * GSC切り離し通知
     * @param url	GSCのURL
     * @param msg	エラーメッセージ
     * @param status	エラーステータス
     */
	public void notifyGscBroken(String url, String msg, String status);

}
