/**
 * 
 */
package org.postgresforest.vm.core;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;

import org.postgresforest.core.Field;
import org.postgresforest.core.Query;
import org.postgresforest.core.ResultCursor;
import org.postgresforest.core.ResultHandler;

public class SimpleResultHandler implements ResultHandler {

		private SQLException error;

        Query m_fromQuery;
        Field[] m_fields;
        Vector m_tuples;
        ResultCursor m_cursor;
        String m_status;
        int m_updateCount;
        long m_insertOID;      
        

        public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {

        	m_fromQuery = fromQuery;
        	m_fields = fields;
        	m_tuples = tuples;
        	m_cursor = cursor;

        }

        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            m_status = status;
            m_updateCount = updateCount;
            m_insertOID = insertOID;
        }

        public void handleWarning(SQLWarning warning) {
//            AbstractJdbc2Statement.this.addWarning(warning);
        }

        public void handleError(SQLException newError) {
            if (error == null)
                error = newError;
            else
                error.setNextException(newError);
        }

        public void handleCompletion() throws SQLException {
            if (error != null)
                throw error;
        }

    	public ResultCursor getCursor() {
    		return m_cursor;
    	}

    	public Field[] getFields() {
    		return m_fields;
    	}

    	public Query getFromQuery() {
    		return m_fromQuery;
    	}

    	public Vector getTuples() {
    		return m_tuples;
    	}

		public long getInsertOID() {
			return m_insertOID;
		}

		public String getStatus() {
			return m_status;
		}

		public int getUpdateCount() {
			return m_updateCount;
		}
    }