/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.vm;

import java.sql.Connection;

/**
 * クエリ情報クラス.
 * リライト済SQLと、接続先のコネクションを保持する。
 *
 */

public class QueryInfo {

	/** リライトSQL */
	protected String m_sql; 

	/**	コネクション */
	protected Connection m_con; 

	/** テーブル名 */
	protected String[] m_table; 

	/** パーティションNo */
	protected int m_partNo; 


	/**
	 * コネクション取得
	 * @return
	 */

	public Connection getConnection() {

		return m_con;

	}

	/**
	 * パーティション番号
	 * @return
	 */

	protected int getPartNo() {

		return m_partNo;

	}

	/**
	 * リライトされたSQLの取得
	 * @return	
	 */

	public String getSql() {

		return m_sql;

	}



	/**
	 * 対象テーブル名
	 * @return
	 */

	protected String[] getTables() {

		return m_table;

	}

	/**
	 * コネクション設定
	 * 
	 * @param connection
	 */

	protected void setConnection(Connection connection) {

		m_con = connection;

	}

	/**
	 * パーティション番号設定
	 * 
	 * @param i
	 */

	protected void setPartNo(int i) {

		m_partNo = i;

	}

	/**
	 * リライトされたSQLの設定
	 * @param string
	 */

	protected void setSql(String string) {

		m_sql = string;

	}

	/**
	 * 対象テーブルの設定
	 * @param string
	 */

	protected void setTable(String[] string) {

		m_table = string;

	}

}
