/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.vm;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

import org.postgresforest.ds.common.BaseDataSource;


/**
 * PostgresForest用DataSouce底クラス.
 * PostgresForestのプロパティ値を追加
 * @since 1.1
 */
public abstract class AbstractForestBaseSource extends BaseDataSource {

	private transient PrintWriter logger;

	public static final int CON_ROUND_ROBIN = 0;
	public static final int CON_FIX = 1;
	
	//Ver2.0 private String m_Primary = "localhost";
	//Ver2.0 private String m_BackUp  = "localhost";
	//Ver2.0
	private String m_GSC = "localhost";
	private int m_Cache_Reflesh = 40;
	private int m_Defect_Timeout = 300;
	private int m_Retry_Count = 0;
	private int m_Distributed_Connection = 0 ;
	private String m_Hash_Class="org.postgresforest.vm.Hash01";


	/**
	 * @return
	 */
	public String getHash_Class() {
		return m_Hash_Class;
	}

	/**
	 * @return
	 * @since 2.0
	 */
	public String getGSC() {
		return m_GSC;
	}



	/**
	 * @param string
	 */
	public void setHash_Class(String string) {
		m_Hash_Class = string;
	}

	/**
	 * @param string
	 * @since 2.0
	 */
	public void setGSC(String string) {
		m_GSC = string;
	}


	/**
	 * @return
	 */
	public int getCache_Reflesh() {
		return m_Cache_Reflesh;
	}

	/**
	 * @return
	 */
	public int getDefect_Timeout() {
		return m_Defect_Timeout;
	}

	/**
	 * @return
	 */
	public int getDistributed_Connection() {
		return m_Distributed_Connection;
	}

	/**
	 * @param i
	 */
	public void setCache_Reflesh(int i) {
		m_Cache_Reflesh = i;
	}

	/**
	 * @param i
	 */
	public void setDefect_Timeout(int i) {
		m_Defect_Timeout = i;
	}

	/**
	 * @param i
	 */
	public void setDistributed_Connection(int i) {
		m_Distributed_Connection = i;
	}


	/* (非 Javadoc)
	 * @see javax.naming.Referenceable#getReference()
	 */
	public Reference getReference() throws NamingException {
		Reference ref = super.getReference();
		ref.add(new StringRefAddr("GSC", m_GSC));
		ref.add(new StringRefAddr("Cache_Reflesh", Integer.toString(m_Cache_Reflesh)));
		ref.add(new StringRefAddr("Defect_Timeout", Integer.toString(m_Defect_Timeout)));
		ref.add(new StringRefAddr("Distributed_Connection", Integer.toString(m_Distributed_Connection)));
		ref.add(new StringRefAddr("Hash_Class", m_Hash_Class));
		ref.add(new StringRefAddr("Distributed_Connection", Integer.toString(m_Distributed_Connection)));
		ref.add(new StringRefAddr("Retry_Count", Integer.toString(m_Retry_Count)));


		return ref;
	}


	/* (非 Javadoc)
	 * @see org.postgresforest.jdbc2.optional.BaseDataSource#getConnection(java.lang.String, java.lang.String)
	 */
	public Connection getConnection(String user, String password)
		throws SQLException {
			try
			{
				Connection con = DriverManager.getConnection(getUrl(), user, password);
				if (logger != null)
				{
					logger.println("Created a non-pooled connection for " + user + " at " + getUrl());
				}
				return con;
			}
			catch (SQLException e)
			{
				if (logger != null)
				{
					logger.println("Failed to create a non-pooled connection for " + user + " at " + getUrl() + ": " + e);
				}
				throw e;
			}
	}
	/**
	 * Generates a DriverManager URL from the other properties supplied.
	 */
	private String getUrl()
	{
		StringBuffer url = new StringBuffer("jdbc:postgresql:datasource:");
		
		url.append("GSC=");
		url.append(m_GSC);
		url.append(";");
		
		url.append("Cache_Reflesh=");
		url.append(m_Cache_Reflesh);
		url.append(";");

		url.append("Defect_Timeout=");
		url.append(m_Defect_Timeout);
		url.append(";");

		url.append("Distributed_Connection=");
		url.append(m_Distributed_Connection);
		url.append(";");

		url.append("Hash_Class=");
		url.append(m_Hash_Class);
		url.append(";");

		url.append("Retry_Count=");
		url.append(m_Retry_Count);

		url.append("@");
		url.append(getDatabaseName());

		return url.toString();
		
	}


	/* (非 Javadoc)
	 * @see org.postgresforest.jdbc2.optional.BaseDataSource#setLogWriter(java.io.PrintWriter)
	 */
	public void setLogWriter(PrintWriter printWriter) throws SQLException {
		logger = printWriter;

		super.setLogWriter(printWriter);
	}

	/**
	 * @return
	 */
	public int getRetry_Count() {
		return m_Retry_Count;
	}

	/**
	 * @param i
	 */
	public void setRetry_Count(int i) {
		m_Retry_Count = i;
	}

}
