package org.postgresforest.test.xa;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;

import junit.framework.TestSuite;

import org.postgresforest.test.TestUtil;

public class XATestSuite extends TestSuite {
    public static TestSuite suite() throws Exception {
        Class.forName("org.postgresforest.Driver");
        TestSuite suite = new TestSuite();
        Connection connection = TestUtil.openDB();

        try
        {
            if (TestUtil.haveMinimumServerVersion(connection, "8.1"))
            {
                suite.addTestSuite(XADataSourceTest.class);
            }
        }
        finally
        {
            connection.close();
        }
        return suite;
    }
}
