package org.postgresforest.tool.util;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.LinkedList;

public class CommandHistory {

	private int m_maxHistory;
	static final FieldPosition pos = new FieldPosition(NumberFormat.INTEGER_FIELD); 
	static final String SEPARATOR = " : "; 
	
	
	protected LinkedList m_commandHis;
	
	public CommandHistory(int max ) {
		super();
		m_commandHis = new LinkedList();
		m_maxHistory = max;
		
	}

	/**
	 * テスト
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO 自動生成されたメソッド・スタブ

		CommandHistory his = new CommandHistory(10);
		his.add("1damda;");
		his.add("2damdadda;");
		his.add("3dadadamda;");
		his.add("4dvzvzxamda;");
		his.add("5damda;");
		his.add("6damdadda;");
		his.add("7dadadamda;");
		his.add("8dvzvzxamda;");
		his.add("9damda;");
		his.add("10damdadda;");
		his.add("11dadadamda;");
		his.add("12dvzvzxa\nmda;");
		his.add("13damda;");
		his.add("14damdadda;");
		his.add("15dadadamda;");
		his.add("16dvzvzxamda;");
		his.add("17damda;");
		his.add("18damdadda;");
		his.add("19dadadamda;");
		his.add("20dvzvzxamda;");
		
		his.printHistory();
	
		System.out.println(his.get(1)); 

		his.printHistory();
		
		
	}

	/**
	 * コマンド追加.
	 * ヒストリにコマンドを追加する
	 * @param Command
	 */
	public void add(String Command) {

		m_commandHis.addLast(Command);
		if(m_commandHis.size() > m_maxHistory){
			m_commandHis.removeFirst();
		}
	}
	
	/**
	 * コマンド取り出し
	 * 指定したインデックスのコマンドを返し、ヒストリの最後に場所を移す
	 * @param index
	 * @return
	 */
	public String get(int index){
		if(index > (m_commandHis.size()-1) || index < 0 )
			return "";
			
			
		String command = (String)m_commandHis.remove(index);
		add(command);
		return command;
	}
	
	/**
	 * コマンドリストを配列で取り出す。
	 * @return
	 */
	public String[] getHistory(){
		
		return  (String[])m_commandHis.toArray(new String[0]);
	}
	
	/**
	 * インデックス番号つきのコマンド履歴を標準出力に表示
	 *
	 */
	public void printHistory() {

		for (int i = 0; i < m_commandHis.size(); i++) {
			String command = (String) m_commandHis.get(i);
			//改行文字を取り出す？
			System.out.println(parse(i,3) + SEPARATOR + replaceLF(command,3));
		}
		
		
	}

	public static String parse(int val, int offset) {
		StringBuffer buf = NumberFormat.getNumberInstance().format(val,
				new StringBuffer(), pos);
		StringBuffer disp = new StringBuffer();
		for (int i = 0; i < offset - pos.getEndIndex(); i++) {
			disp.append(' ');
		}
		disp.append(buf.toString());
		return disp.toString();
	}

	public static String replaceLF(String command, int offset) {

		
		char[] fill = new char[offset+SEPARATOR.length()];
		Arrays.fill(fill ,' ');
		String LF_OFFSET = new String("\n"+String.valueOf(fill)); 
		
		return command.replaceAll("\n", LF_OFFSET);
	}
	
}
