#!/bin/sh

pushd ../../../../../..
ant
popd

. ./env.conf

rm -rf copy_config create_config create_database create_gsc create_index create_instance create_table drop_config drop_database drop_dbinstance drop_gsc drop_index drop_instance drop_table init_gsc part_table part_table2 set_config set_instance show_config show_database show_gsc show_instance show_table unpart_table


PATH=${PGHOME}/bin:${PATH}
export PATH

LD_LIBRARY_PATH=/usr/java/j2sdk1.4.2_13/jre/lib/i386:/usr/java/j2sdk1.4.2_13/jre/lib/i386/server
export LD_LIBRARY_PATH

CLASSPATH=/usr/local/pgsql815lt/lib/pljava/pljava.jar:/home/snaga/tmp/forest40/lib/org.postgresforest.tool.lib.jar:/home/snaga/tmp/forest40/share/postgresforest40.jar
export CLASSPATH

for i in {0,1,2,3};
  do PGDATA=`pwd`/$i;
     pg_ctl -D ${PGDATA} stop;
     rm -rf ${PGDATA};
     initdb -D ${PGDATA} --no-locale;

     PORT=`expr 9998 + $i`;
     pg_ctl -D ${PGDATA} -w -l ${PGDATA}/pg.log -o "-p ${PORT}" start;
     createuser -s -p ${PORT} ${USER};
     createdb -U ${USER} -p ${PORT} forest_template;

     psql -U ${USER} -p ${PORT} -f /home/snaga/tmp/forest40/share/forest_init.sql forest_template;

     java -classpath /home/snaga/tmp/forest40/share/postgresql-8.1-407.jdbc3.jar:/usr/local/pgsql815lt/lib/pljava/deploy.jar \
                org.postgresql.pljava.deploy.Deployer \
                -install \
                -port ${PORT} \
                -database forest_template \
                -user ${USER}

     psql -U ${USER} -p ${PORT} -f /home/snaga/tmp/forest40/share/forest_pljava_init.sql forest_template;
     psql -U ${USER} -p ${PORT} forest_template <<EOF
SELECT sqlj.install_jar('file:///home/snaga/tmp/forest40/lib/org.postgresforest.tool.lib.jar','PartitionUtils',true);
EOF
     psql -U ${USER} -p ${PORT} -f ../../../../../../share/forest_pljava_funcs.sql forest_template;
done;
