#!/bin/sh

. ./common/test_init_gsc.sh | tee result

. ./common/dropdb.sh testdb

./run_tool.sh<<EOF
show instance;
create instance ${HOST_1} ${PORT_1};
show instance;
create instance ${HOST_2} ${PORT_2};
show instance;
create instance ${HOST_3} ${PORT_3};
show instance;

check gsc;

show db;
create db testdb(0,2,1,3) with "encoding='utf-8'";
show db;

open db testdb;
create table t1 ( uid integer primary key, name text not null );
create index t1_name_idx on t1(name);

show table t1;
part table t1 (uid) 3;
show table t1;
show priority t1;
show table;
close db;
EOF

./run_tool.sh<<EOF
open db testdb;
show table t1;
unpart table t1;
show table t1;
part table t1 (uid) 3;
show table t1;
close db;
EOF
