package org.postgresforest.tool.lib;

/**
 * Javaにおけるbyte[]を、PostgreSQLのbytea型との間でマッピングする上で、
 * 必要となるエスケープ処理などを提供するユーティリティクラス
 */
public class ByteaUtils {

	private static String toOctalString(int i)
	{
		String s = java.lang.Integer.toOctalString(i);

		s = (s.length()<3) ? ("0" + s) : s;
		s = (s.length()<3) ? ("0" + s) : s;

		return s;
	}

	/**
	 * byte[]の配列を、PostgreSQLのbytea型に入力できる形式の
	 * 文字列表現に変換する。
	 *
	 * 変換ルールは以下を参照のこと。
	 *
	 * 「バイナリ列データ型」
	 * http://www.postgresql.jp/document/pg815doc/html/datatype-binary.html
	 *
	 * @param b byte型の配列
	 *
	 * @return String PostgreSQLのbytea型への入力が可能な文字列表現
	 */
	public static String encodeBytes(byte[] b)
	{
		String s = "";

		for (int i=0 ; i<b.length ; i++)
		{
			int c = b[i];

			if ( c<0 )
				c = c + 256;

			if ( c==0 ) {
				s = s + "\\\\000";
			}
			else if ( c==39 ) {
				s = s + "\\\\047";
			}
			else if ( c==92 ) {
				s = s + "\\\\134";
			}
			else if ( 1<=c && c<=31 ) {
				s = s + "\\\\" + toOctalString(c);
			}
			else if ( 127<=c && c<=255 ) {
				s = s + "\\\\" + toOctalString(c);
			}
			else {
				s = s + java.lang.Character.toString((char)c);
			}
		}

		return s;
   	}
}
