/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.config;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.postgresforest.tool.ForestToolPlugin;
import org.postgresforest.tool.bean.ConfigInfo;
import org.postgresforest.tool.util.Messages;

/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

public class ConfigLabelProvider extends LabelProvider implements ITableLabelProvider {

	DateFormat m_dtfmt = SimpleDateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.LONG);
	static Image m_checked_image = ForestToolPlugin.getDefault().getImageRegistry().getDescriptor(ForestToolPlugin.IMG_CHECKED).createImage();
	static Image m_unchecked_image = ForestToolPlugin.getDefault().getImageRegistry().getDescriptor(ForestToolPlugin.IMG_UNCHECKED).createImage();
	
	//MASUCOMMENT Jԍ
	static final int FOREST_CONFIG_CONFIGID_COLUMN = 			0;
	static final int FOREST_CONFIG_DESCRIPTION_COLUMN = 		1;
	static final int FOREST_CONFIG_CACHE_REFLESH_COLUMN = 		2;
	static final int FOREST_CONFIG_RETRY_COUNT_COLUMN = 		3;
	static final int FOREST_CONFIG_DEFECT_TIMEOUT_COLUMN = 		4;
	static final int FOREST_CONFIG_DISTRIBUTED_CONNECTION_COLUMN = 5;
	static final int FOREST_CONFIG_PERTITION_MODE_COLUMN = 		6;
	static final int FOREST_CONFIG_SYNCRONIZE_MODE_COLUMN = 	7;
	static final int FOREST_CONFIG_UPDATE_DATE_COLUMN = 		8;

	
	public String getColumnText(Object element, int columnIndex) {
		ConfigInfo configInfo = (ConfigInfo)element;
		String status;
		switch(columnIndex) {
		case FOREST_CONFIG_CONFIGID_COLUMN:
			return configInfo.getConfigId();
		case FOREST_CONFIG_DESCRIPTION_COLUMN:
			String desc = configInfo.getDescription();
			if(desc == null){
				return "";
			}else{
				return configInfo.getDescription();
			} 
		//MASUCOMMENT 2005/11/07 ǉ
		case FOREST_CONFIG_CACHE_REFLESH_COLUMN:
			long cache_refresh = configInfo.getCacheReflesh();
			return Long.toString(cache_refresh);
		case FOREST_CONFIG_RETRY_COUNT_COLUMN:
			long retry_count = configInfo.getRetryCount();
			return Long.toString(retry_count);
		case FOREST_CONFIG_DEFECT_TIMEOUT_COLUMN:
			long defect_timeout = configInfo.getDefectTimeout();
			return Long.toString(defect_timeout);
		case FOREST_CONFIG_DISTRIBUTED_CONNECTION_COLUMN:
			long distributed_connection = configInfo.getDistributedCon();
			String distribution_type_name = "";
			// MASUCOMMENT distributed_connection0̎̓Ehrł̑͌ŒƂ
			if(distributed_connection == 0){
				distribution_type_name = Messages.getString("form.config.distribution.roundrobin");
			}else{
				distribution_type_name = Messages.getString("form.config.distribution.fix");
			}
			return distribution_type_name;
		case FOREST_CONFIG_PERTITION_MODE_COLUMN:
			return "";
		case FOREST_CONFIG_SYNCRONIZE_MODE_COLUMN:
			return "";

		case FOREST_CONFIG_UPDATE_DATE_COLUMN:
			return m_dtfmt.format(configInfo.getUpdateDate());
		}
		return null;
	}
	
	public Image getColumnImage(Object element, int columnIndex) {	

		ConfigInfo info = null;
		
		if(	columnIndex == FOREST_CONFIG_PERTITION_MODE_COLUMN || 
			columnIndex == FOREST_CONFIG_SYNCRONIZE_MODE_COLUMN){
			info =(ConfigInfo)element;
			if(columnIndex == FOREST_CONFIG_PERTITION_MODE_COLUMN ){
				//MASUCOMMENT p[eBV[h̃`FbN{bNX
				if(info.isPertitionMode()){
					return m_checked_image;
				}else{
					return m_unchecked_image;
				}
			}else if(columnIndex == FOREST_CONFIG_SYNCRONIZE_MODE_COLUMN){
				//MASUCOMMENT [h̃`FbN{bNX
				if(info.isSyncMode()){
					return m_checked_image;
				}else{
					return m_unchecked_image;
				}
			}
		}
		return null;
	}
	//TODOMASU ȂH\[gp
	public static Object getConfigInfoColumnData(int lColumnNumber, ConfigInfo lConfigInfo){
		Object retObject = null;
		switch (lColumnNumber){
		case FOREST_CONFIG_CONFIGID_COLUMN:
			retObject = (Object)lConfigInfo.getConfigId();
			break;
		case FOREST_CONFIG_DESCRIPTION_COLUMN:
			retObject = (Object)lConfigInfo.getDescription();
			break;
		case FOREST_CONFIG_CACHE_REFLESH_COLUMN:
			long cache_refresh = lConfigInfo.getCacheReflesh();
			retObject = (Object)new Long(cache_refresh);
			break;
		case FOREST_CONFIG_RETRY_COUNT_COLUMN:
			long retry_count = lConfigInfo.getRetryCount();
			retObject = (Object)new Long(retry_count);
			break;
		case FOREST_CONFIG_DEFECT_TIMEOUT_COLUMN:
			long defect_timeout = lConfigInfo.getDefectTimeout();
			retObject = (Object)new Long(defect_timeout);
			break;
		case FOREST_CONFIG_DISTRIBUTED_CONNECTION_COLUMN:
			long distributed_connection = lConfigInfo.getDistributedCon();
			retObject = (Object)new Long(distributed_connection);
			break;
		case FOREST_CONFIG_PERTITION_MODE_COLUMN:
			boolean pertition_mode = lConfigInfo.isPertitionMode();
			retObject = (Object)new Boolean(pertition_mode);
			break;
		case FOREST_CONFIG_SYNCRONIZE_MODE_COLUMN:
			boolean syncronize_mode = lConfigInfo.isSyncMode();
			retObject= (Object)new Boolean(syncronize_mode);
			break;
	
		case FOREST_CONFIG_UPDATE_DATE_COLUMN:
			 retObject = (Object)lConfigInfo.getUpdateDate();
			 break;
		}
			
		return retObject;
		
	}

}