/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.action;

import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.postgresforest.tool.action.HashAction;
import org.postgresforest.tool.action.PartitionAction;
import org.postgresforest.tool.bean.ColumnInfo;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.dialog.partition.Partition2Dialog;
import org.postgresforest.tool.dialog.partition.PartitionDialog;
import org.postgresforest.tool.util.ErrorLog;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.util.MsgDialogUtil;
import org.postgresforest.tool.util.SessionProperty;
import org.postgresforest.tool.view.ViewControl;

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv: EBhE - ݒ - Java - R[hEX^C -
 * R[hEev[g
 */
public class MakePartitionAction extends ActionBase {

	public static final String ID = "org.postgresforest.tool.view.action.MakePartitionAction";

	protected PartitionDialog m_dialog;

	protected Partition2Dialog m_dialog2;

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	public void init(IViewPart view) {

		super.init(view);

		m_dialog = new PartitionDialog();
		m_dialog2 = new Partition2Dialog();

		m_dialog.setRePartition(false);

	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {

		TableInfo tableInfo = (TableInfo) SessionProperty.get("tableInfo");
		GSCdata gsc = (GSCdata)SessionProperty.get("gsc");
		String dbName = (String)SessionProperty.get("selectDb");
	
		//̓`FbN
		if (!validate(tableInfo))
			return;

		
		
		//T[o擾

		
		m_dialog.setPartitionMax(tableInfo.getServer().size());
		m_dialog.setTableName(tableInfo.getName());
		m_dialog.setDbName(dbName);
		m_dialog.setHashName(tableInfo.getHashName());
		HashAction hashAction = new HashAction(gsc);
		try {
			m_dialog.setHashList(hashAction.getHashList());
		} catch (Exception e1) {
			ErrorLog.log("", e1);
		    MsgDialogUtil.err(e1.getLocalizedMessage());
		}

		//_CAO\
		if (m_dialog.open() == Window.OK) {

			int partitionCount = m_dialog.getPartitionCount();
			//p[eBV2
			if (m_dialog.isPartition2()) {
				m_dialog2.setPartCount(partitionCount);
				if (m_dialog2.open() == Window.OK) {
					tableInfo.setPartType(TableInfo.TYPE_PARTITION_2);
				} else {
					return;
				}

			} else {
				tableInfo.setPartType(TableInfo.TYPE_PARTITION);
			}

			
			PartitionAction makePartition = new PartitionAction(gsc,dbName);
			boolean result = false;
			try {
				result = makePartition.make(m_dialog.isDataShift(),	
											partitionCount,
											tableInfo,
											m_dialog.getHashName());
			} catch (Exception e) {
				ErrorLog.log("", e);
			    MsgDialogUtil.err(e.getLocalizedMessage());
			}

			ViewControl.updateUserDataView("",dbName, tableInfo.getName());
		}

	}

	protected boolean validate(TableInfo tableInfo) {

		//p[eBVڑI`FbN
		boolean isChecked = false;

		for (Iterator iter = tableInfo.getColumn().iterator(); iter.hasNext();) {
			ColumnInfo columnInfo = (ColumnInfo) iter.next();
			if (columnInfo.isPartition()) {
				isChecked = true;
				break;
			}
		}
		if (!isChecked) {
			String msg = Messages.getString("errors.required", Messages
					.getString("form.partition.Attribute"));

			MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getShell(), SWT.OK
					| SWT.ICON_WARNING);

			messageBox.setText("");
			messageBox.setMessage(msg);

			messageBox.open();

		}

		return isChecked;

	}

}