/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IViewPart;
import org.postgresforest.tool.action.ConfigAction;
import org.postgresforest.tool.bean.ConfigInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.dialog.config.ConfigDialog;
import org.postgresforest.tool.util.ErrorLog;
import org.postgresforest.tool.util.MsgDialogUtil;
import org.postgresforest.tool.util.SessionProperty;
import org.postgresforest.tool.view.config.ConfigView;



/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class CopyConfigAction extends ActionBase {
	private ConfigDialog m_dialog;
	public static final String ID = "org.postgresforest.tool.view.action.CopyConfigAction";
	public final static String COPY_FILENAME_HEADER = "CopyOf";
	
	public void init(IViewPart view) {
		super.init(view);
		m_dialog = new ConfigDialog(true);

	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		//_CAO\
		
		ConfigView view = (ConfigView)m_view;
		String id = view.getSelectId();

		GSCdata gsc = (GSCdata)SessionProperty.get("gsc");
		ConfigAction configAction = new ConfigAction((GSCdata)SessionProperty.get("gsc"));
		try {
			ConfigInfo configInfo = (ConfigInfo)configAction.get(id).clone();
			configInfo.setConfigId(COPY_FILENAME_HEADER + id);
		
			m_dialog.setConfigInfo(configInfo);
		} catch (Exception e1) {
			ErrorLog.log("", e1);
		    MsgDialogUtil.err(e1.getLocalizedMessage());
		}

		if (m_dialog.open() == Window.OK) {
			try{
			configAction.add(m_dialog.getConfigInfo());
			}catch (Exception e1) {
				ErrorLog.log("", e1);
			    MsgDialogUtil.err(e1.getLocalizedMessage());
			}
		}
		m_view.update();
	}


}
