/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.action;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IViewPart;
import org.postgresforest.tool.action.HashAction;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.dialog.hash.HashDialog;
import org.postgresforest.tool.util.ErrorLog;
import org.postgresforest.tool.util.MsgDialogUtil;
import org.postgresforest.tool.util.SessionProperty;

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv: EBhE - ݒ - Java - R[hEX^C -
 * R[hEev[g
 */
public class AddHashAction extends ActionBase {
    public static final String ID = "org.postgresforest.tool.view.action.AddHashAction";
	private HashDialog m_dialog;

	public void init(IViewPart view) {
		super.init(view);
		m_dialog = new HashDialog();

	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		//_CAO\
		if (m_dialog.open() == Window.OK) {
			String className = m_dialog.getClassName();
			String description = m_dialog.getDescription();
			String fileName = m_dialog.getFileName();

			byte[] byteImg = null;
			try {
				byteImg = getFileByteImage(fileName);
			} catch (Exception e1) {
				ErrorLog.log("", e1);
			    MsgDialogUtil.err(e1.getLocalizedMessage());
				return;
			}
			//ZbVvpeBO[oVXeJ^O擾
			GSCdata gsc = (GSCdata)SessionProperty.get("gsc");
			
			
			HashAction hashAction = new HashAction(gsc);
			hashAction.addHash(className, description, byteImg);
			
			m_view.update();
		}
	}

	/**
	 * @param fileName
	 * @return
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	private byte[] getFileByteImage(String fileName) throws FileNotFoundException, IOException {
		byte[] buf = new byte[64];
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		FileInputStream in = new FileInputStream(fileName);

		int nBytes;

		while ((nBytes = in.read(buf)) > 0)
			out.write(buf, 0, nBytes);

		in.close();

		byte[] byteImg = out.toByteArray();
		out.close();
		return byteImg;
	}

}