/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.util;



import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.postgresforest.tool.bean.BrokenLogInfo;
import org.postgresforest.tool.view.brokenlog.BrokenLogLabelProvider;

/**
 *
 */
public class TableColumnSelectionListener implements SelectionListener {
	protected int m_number = 0;
	protected Table m_table = null;
	protected TableViewer m_tableViewer = null;
	protected int m_sortType = -1;
	
	public TableColumnSelectionListener(int lColumnNumber,TableViewer lTableViewer){
		this.m_tableViewer = lTableViewer;
		this.m_number = lColumnNumber;
	}

	//TODOMASU Rgt
	//
	public void widgetSelected(SelectionEvent e){
		int columnNumber = this.getColumnNumber();
		TableColumnViewerSorter sorter = new TableColumnViewerSorter(this.getColumnNumber());
		reverseSortType();
		m_tableViewer.setSorter(sorter);
	}
	//MASUCOMMENT ftHgOverride郁\bhǓɍsȂƂ͂Ȃ
	public void widgetDefaultSelected(SelectionEvent e){
		
	}
	public int getColumnNumber(){
		return m_number;
	}

	public void setColumnNumber(int number){
		m_number = number;
	}
	public void reverseSortType(){
		m_sortType = m_sortType * -1;
		
	}
	private int getSortType(){
		return m_sortType;
		
	}
	class TableColumnViewerSorter extends ViewerSorter{
		public int m_columnNumber = 0;
		
		public TableColumnViewerSorter(int lColumnNumber){
			this.m_columnNumber = lColumnNumber;
		}
		public int getColumnNumber(){
			return this.m_columnNumber;
		}
		public int compare(Viewer viewer, Object e1, Object e2){
			int ret = 0;
			Object e1_data = null;
			Object e2_data = null;
			String strE1Data = "";
			String strE2Data = "";
			TableViewer tableViewer = null;
			
			if (	(e1 instanceof BrokenLogInfo) &&
					(e2 instanceof BrokenLogInfo)){
				e1_data = BrokenLogLabelProvider.
					getData(this.getColumnNumber(),(BrokenLogInfo)e1);
				e2_data = BrokenLogLabelProvider.
					getData(this.getColumnNumber(),(BrokenLogInfo)e2);
				
				strE1Data = e1_data.toString();
				strE2Data = e2_data.toString();
				ret = strE1Data.compareTo(strE2Data);
				ret = getSortType() * ret;
				
			}
			return ret;
		}
		
	}
}
