/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class MsgDialogUtil {

	static private Shell getShell(){
		return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
	
	}
	
	static public void info(String messageKey ){
		MessageDialog.openInformation(getShell(),
			"Infomation",
			Messages.getString(messageKey));
	}

	static public void err(String messageKey ){
		MessageDialog.openError(getShell(),
			"Error",
			Messages.getString(messageKey));
	}

	static public void err(	String key, String arg){
		MessageDialog.openError(getShell(),
			"Error",
			Messages.getString(key,arg));
	}
	
	static public void err(String key, Object[] args){
		MessageDialog.openError(getShell(),
			"Error",
			Messages.getString(key,args));
	}
		
	
	static public void err(String messageKey, IStatus status ){

		ErrorDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 
				"Error", 
				Messages.getString(messageKey), 
				status);

	}

	static public boolean question(String messageKey ){
		return MessageDialog.openQuestion(getShell(),
			"Question",
			Messages.getString(messageKey));
	}
	
}
